/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessageSerializer;

public class RestoreSnapshotMessageImpl
implements RestoreSnapshotMessage,
Cloneable {
    public static final short GROUP_TYPE = 1000;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final String encryptionProviderName;
    @IgniteToStringInclude
    private final String source;
    @IgniteToStringInclude
    private final Set<String> tableNames;
    @IgniteToStringInclude
    private final UUID targetSnapshotId;
    @IgniteToStringInclude
    private final boolean force;
    @IgniteToStringInclude
    private final Set<String> structureNames;

    private RestoreSnapshotMessageImpl(String encryptionProviderName, String source, Set<String> tableNames, UUID targetSnapshotId, boolean force, Set<String> structureNames) {
        this.encryptionProviderName = encryptionProviderName;
        this.source = source;
        this.tableNames = tableNames;
        this.targetSnapshotId = targetSnapshotId;
        this.force = force;
        this.structureNames = structureNames;
    }

    @Override
    public String encryptionProviderName() {
        return this.encryptionProviderName;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @Override
    public UUID targetSnapshotId() {
        return this.targetSnapshotId;
    }

    @Override
    public boolean force() {
        return this.force;
    }

    @Override
    public Set<String> structureNames() {
        return this.structureNames;
    }

    public MessageSerializer serializer() {
        return RestoreSnapshotMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1000;
    }

    public String toString() {
        return S.toString(RestoreSnapshotMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RestoreSnapshotMessageImpl otherMessage = (RestoreSnapshotMessageImpl)other;
        return Objects.equals(this.encryptionProviderName, otherMessage.encryptionProviderName) && Objects.equals(this.source, otherMessage.source) && Objects.equals(this.tableNames, otherMessage.tableNames) && Objects.equals(this.targetSnapshotId, otherMessage.targetSnapshotId) && Objects.equals(this.structureNames, otherMessage.structureNames) && this.force == otherMessage.force;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.force, this.encryptionProviderName, this.source, this.tableNames, this.targetSnapshotId, this.structureNames);
        return result;
    }

    public RestoreSnapshotMessageImpl clone() {
        try {
            return (RestoreSnapshotMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RestoreSnapshotMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RestoreSnapshotMessageBuilder {
        private String encryptionProviderName;
        private String source;
        private Set<String> tableNames;
        private UUID targetSnapshotId;
        private boolean force;
        private Set<String> structureNames;

        private Builder() {
        }

        @Override
        public RestoreSnapshotMessageBuilder encryptionProviderName(String encryptionProviderName) {
            this.encryptionProviderName = encryptionProviderName;
            return this;
        }

        @Override
        public RestoreSnapshotMessageBuilder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public RestoreSnapshotMessageBuilder tableNames(Set<String> tableNames) {
            Objects.requireNonNull(tableNames, "tableNames is not marked @Nullable");
            this.tableNames = tableNames;
            return this;
        }

        @Override
        public RestoreSnapshotMessageBuilder targetSnapshotId(UUID targetSnapshotId) {
            Objects.requireNonNull(targetSnapshotId, "targetSnapshotId is not marked @Nullable");
            this.targetSnapshotId = targetSnapshotId;
            return this;
        }

        @Override
        public RestoreSnapshotMessageBuilder force(boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public RestoreSnapshotMessageBuilder structureNames(Set<String> structureNames) {
            Objects.requireNonNull(structureNames, "structureNames is not marked @Nullable");
            this.structureNames = structureNames;
            return this;
        }

        @Override
        public String encryptionProviderName() {
            return this.encryptionProviderName;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public Set<String> tableNames() {
            return this.tableNames;
        }

        @Override
        public UUID targetSnapshotId() {
            return this.targetSnapshotId;
        }

        @Override
        public boolean force() {
            return this.force;
        }

        @Override
        public Set<String> structureNames() {
            return this.structureNames;
        }

        @Override
        public RestoreSnapshotMessage build() {
            return new RestoreSnapshotMessageImpl(this.encryptionProviderName, this.source, Objects.requireNonNull(this.tableNames, "tableNames is not marked @Nullable"), Objects.requireNonNull(this.targetSnapshotId, "targetSnapshotId is not marked @Nullable"), this.force, Objects.requireNonNull(this.structureNames, "structureNames is not marked @Nullable"));
        }

        @Override
        public RestoreSnapshotMessage buildDeserialized() {
            return new RestoreSnapshotMessageImpl(this.encryptionProviderName, this.source, this.tableNames, this.targetSnapshotId, this.force, this.structureNames);
        }
    }
}

