/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.structure;

import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;

public class Structure {
    private final int id;
    private final QualifiedName name;
    private final CatalogTableDescriptor systemTable;

    public Structure(int id, QualifiedName name, CatalogTableDescriptor systemTable) {
        this.id = id;
        this.name = name;
        this.systemTable = systemTable;
    }

    public CatalogTableDescriptor systemTable() {
        return this.systemTable;
    }

    public QualifiedName name() {
        return this.name;
    }

    public int id() {
        return this.id;
    }

    static Structure toStructure(int schemaId, String structureName, int structureId, Catalog catalog, int tableId) {
        return new Structure(structureId, QualifiedNameHelper.fromNormalized((String)catalog.schema(schemaId).name(), (String)structureName), catalog.table(tableId));
    }
}

