/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.catalog.CreateStructuresCommand;
import org.gridgain.internal.snapshots.catalog.DropExistingStructuresCommand;
import org.gridgain.internal.snapshots.catalog.DropExistingTablesCommand;
import org.gridgain.internal.snapshots.catalog.RenameTemporaryTablesCommand;
import org.gridgain.internal.snapshots.catalog.SwitchTablesAccessCommand;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.LocalSnapshotStateListener;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.meta.ObjectDescriptorView;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;

class RestoreSnapshotLocalStateWatch
extends LocalSnapshotStateListener {
    private final RestoreSnapshotGlobalState snapshotState;
    private final SnapshotMeta targetSnapshotMeta;

    RestoreSnapshotLocalStateWatch(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState, RestoreSnapshotGlobalState initialState, SnapshotMeta targetSnapshotMeta) {
        super(context, snapshotCoordinatorState, initialState.operationId(), initialState.nodeNames());
        this.snapshotState = initialState;
        this.targetSnapshotMeta = targetSnapshotMeta;
    }

    SnapshotMeta targetSnapshotMeta() {
        return this.targetSnapshotMeta;
    }

    @Override
    protected String nodeNameFromKey(byte[] key) {
        return MetaStorageKeys.nodeNameFromRestoreLocalStateKey(key);
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotCompleteImpl(UUID operationId, String nodeName) {
        Map<String, List<String>> tableNamesBySchema = this.targetSnapshotMeta.tableSnapshotMetas().stream().map(tableSnapshotMeta -> tableSnapshotMeta.schema().tableDescriptor()).collect(Collectors.groupingBy(TableDescriptorView::schemaName, Collectors.mapping(ObjectDescriptorView::name, Collectors.toList())));
        List<CreateStructuresCommand> commands = List.of(SwitchTablesAccessCommand.unlockTables(this.targetSnapshotMeta), new DropExistingStructuresCommand(this.targetSnapshotMeta), new DropExistingTablesCommand(tableNamesBySchema), new RenameTemporaryTablesCommand(SnapshotManager.tmpTableNamePrefix(this.snapshotState.operationId()), this.targetSnapshotMeta), new CreateStructuresCommand(this.targetSnapshotMeta));
        return this.context.catalogManager().execute(commands).thenApplyAsync(v -> this.completeSnapshot(SnapshotStatus.COMPLETED, ""), (Executor)this.context.threadPool());
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotFailedImpl(UUID operationId, String nodeName, String message) {
        String tmpTablePrefix = SnapshotManager.tmpTableNamePrefix(this.snapshotState.operationId());
        Map<String, List<String>> tableNamesBySchema = this.targetSnapshotMeta.tableSnapshotMetas().stream().map(tableSnapshotMeta -> tableSnapshotMeta.schema().tableDescriptor()).collect(Collectors.groupingBy(TableDescriptorView::schemaName, Collectors.mapping(tableView -> tmpTablePrefix + tableView.name(), Collectors.toList())));
        List<DropExistingTablesCommand> commands = List.of(SwitchTablesAccessCommand.unlockTables(this.targetSnapshotMeta), new DropExistingTablesCommand(tableNamesBySchema));
        return this.context.catalogManager().execute(commands).thenApplyAsync(v -> this.completeSnapshot(SnapshotStatus.FAILED, message), (Executor)this.context.threadPool());
    }

    private List<Operation> completeSnapshot(SnapshotStatus status, String description) {
        RestoreSnapshotGlobalState newGlobalState = new RestoreSnapshotGlobalState(this.snapshotState.operationId(), status, this.snapshotState.nodeNames(), this.snapshotState.tableNames(), this.snapshotState.structureNames(), this.snapshotState.targetSnapshotId(), this.snapshotState.catalogVersion(), this.snapshotState.startTime(), description, this.snapshotState.snapshotUri(), this.snapshotState.encryptionProviderName(), this.snapshotState.force());
        ArrayList<Operation> operations = new ArrayList<Operation>(this.snapshotState.nodeNames().size() + 2);
        operations.add(Operations.put((ByteArray)MetaStorageKeys.restoreSnapshotGlobalStateKey(this.snapshotState.operationId()), (byte[])RestoreSnapshotGlobalStateSerializer.serialize(newGlobalState)));
        operations.add(Operations.remove((ByteArray)MetaStorageKeys.restoreSnapshotLockKey()));
        for (String nodeName : this.snapshotState.nodeNames()) {
            operations.add(Operations.remove((ByteArray)MetaStorageKeys.restoreSnapshotLocalStateKey(this.snapshotState.operationId(), nodeName)));
        }
        return operations;
    }
}

