/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.jetbrains.annotations.TestOnly;

public class OngoingSnapshotOperations {
    private final ConcurrentMap<UUID, SnapshotContext<?>> ongoingSnapshotOperationById = new ConcurrentHashMap();
    private boolean stopped = false;
    private final Object stoppedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerSnapshotOperation(SnapshotContext<?> snapshotContext) {
        Object object = this.stoppedLock;
        synchronized (object) {
            if (this.stopped) {
                return false;
            }
            this.ongoingSnapshotOperationById.put(snapshotContext.operationId(), snapshotContext);
        }
        snapshotContext.completionFuture().whenComplete((v, e) -> this.ongoingSnapshotOperationById.remove(snapshotContext.operationId()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> cancelAllSnapshotsOperationsDueToLocalFailure() {
        Object object = this.stoppedLock;
        synchronized (object) {
            this.stopped = true;
        }
        CompletableFuture[] cancelFutures = (CompletableFuture[])this.ongoingSnapshotOperationById.values().stream().map(snapshotContext -> {
            snapshotContext.cancel();
            return snapshotContext.completionFuture();
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(cancelFutures);
    }

    CompletableFuture<Void> cancelSnapshotOperationDueToRemoteFailure(UUID operationId) {
        SnapshotContext snapshotContext = (SnapshotContext)this.ongoingSnapshotOperationById.get(operationId);
        if (snapshotContext == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        snapshotContext.cancelByCoordinator();
        return snapshotContext.completionFuture();
    }

    @TestOnly
    public Collection<SnapshotContext<?>> getAllOperations() {
        return this.ongoingSnapshotOperationById.values();
    }
}

