/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import org.apache.ignite.internal.util.IgniteUtils;

class FsyncWritableByteChannel
implements WritableByteChannel {
    private final Path path;
    private final FileChannel delegate;

    FsyncWritableByteChannel(Path path, FileChannel delegate) {
        this.path = path;
        this.delegate = delegate;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        try (FileChannel fileChannel = this.delegate;){
            if (this.delegate.isOpen()) {
                this.delegate.force(true);
            }
            IgniteUtils.fsyncDir((Path)this.path.getParent());
        }
    }
}

