/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;

class EncryptedReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel channel;
    private final DisposableByteBuffer disposableBuffer;
    private final SnapshotEncryptor encryptor;

    EncryptedReadableByteChannel(SnapshotEncryptor encryptor, ReadableByteChannel channel, DisposableByteBuffer disposableBuffer) {
        this.channel = channel;
        this.disposableBuffer = disposableBuffer;
        this.encryptor = encryptor;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        ByteBuffer buffer = this.buffer();
        while (buffer.remaining() > 0) {
            int channelRead = this.channel.read(buffer);
            if (channelRead != -1) continue;
            if (buffer.position() != 0) break;
            return -1;
        }
        int startPosition = dst.position();
        buffer.flip();
        this.encryptor.decrypt(buffer, dst);
        return dst.position() - startPosition;
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.disposableBuffer.buffer();
        buffer.rewind();
        return buffer;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.disposableBuffer.dispose();
        this.channel.close();
    }
}

