/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.UpdateProducer;
import org.apache.ignite.internal.catalog.commands.SwitchTableAccessCommand;
import org.apache.ignite.internal.catalog.commands.SwitchTableAccessCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;

public class SwitchTablesAccessCommand
implements CatalogCommand {
    private final SnapshotMeta snapshotMeta;
    private final boolean lock;

    private SwitchTablesAccessCommand(SnapshotMeta snapshotMeta, boolean lock) {
        this.snapshotMeta = snapshotMeta;
        this.lock = lock;
    }

    public static SwitchTablesAccessCommand lockTables(SnapshotMeta snapshotMeta) {
        return new SwitchTablesAccessCommand(snapshotMeta, true);
    }

    public static SwitchTablesAccessCommand unlockTables(SnapshotMeta snapshotMeta) {
        return new SwitchTablesAccessCommand(snapshotMeta, false);
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        for (TableSnapshotMeta tableSnapshotMeta : this.snapshotMeta.tableSnapshotMetas()) {
            CatalogTableDescriptor tableDescriptor;
            TableDescriptorView tableView = tableSnapshotMeta.schema().tableDescriptor();
            CatalogSchemaDescriptor schemaDescriptor = catalog.schema(tableView.schemaName());
            if (schemaDescriptor == null || (tableDescriptor = schemaDescriptor.table(tableView.name())) == null || tableDescriptor.cache()) continue;
            CatalogCommand lockTableCommand = ((SwitchTableAccessCommandBuilder)((SwitchTableAccessCommandBuilder)SwitchTableAccessCommand.builder().schemaName(tableView.schemaName())).tableName(tableView.name())).lock(this.lock).validateSystemSchemas(false).build();
            commandState.applyCommand((UpdateProducer)lockTableCommand);
        }
        return commandState.updateEntries();
    }
}

