/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.catalog.storage.DropMapEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.MapDescriptorView;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.jetbrains.annotations.Nullable;

public class DropExistingStructuresCommand
implements CatalogCommand {
    private final SnapshotMeta snapshotMeta;

    public DropExistingStructuresCommand(SnapshotMeta snapshotMeta) {
        this.snapshotMeta = snapshotMeta;
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        DropExistingStructuresCommand.dropStructures(catalog, commandState, this.snapshotMeta.structureDescriptors());
        return commandState.updateEntries();
    }

    private static void dropStructures(Catalog catalog, CommandState commandState, @Nullable Collection<? extends StructureView> views) {
        if (views == null) {
            return;
        }
        for (StructureView structureView : views) {
            CatalogMapDescriptor existingMap;
            String schemaName = structureView.schemaName();
            if (!(structureView instanceof MapDescriptorView) || (existingMap = catalog.map(schemaName, structureView.name())) == null) continue;
            commandState.applyCommand((UpdateEntry)new DropMapEntry(existingMap.id()));
        }
    }
}

