/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.zip.CRC32C;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowUpgrader;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.gridgain.internal.snapshots.buffer.ChecksumChannel;

public class RowSnapshotWriter
implements ManuallyCloseable {
    public static final byte TOMBSTONE_HEADER_BYTE = 24;
    public static final ByteOrder BYTE_ORDER = BinaryTuple.ORDER;
    public static final int UUID_SIZE = 16;
    private static final byte[] TOMBSTONE_HEADER_BYTES = new byte[]{24};
    private final ByteBuffer rowIdBuffer = ByteBuffer.allocate(16).order(BYTE_ORDER);
    private long rowsWritten = 0L;
    private final BinaryRowUpgrader rowUpgrader;
    private final WritableByteChannel buffer;
    private final WritableByteChannel channel;

    RowSnapshotWriter(WritableByteChannel channel, BinaryRowUpgrader rowUpgrader) {
        this.channel = channel;
        this.rowUpgrader = rowUpgrader;
        this.buffer = new ChecksumChannel(channel, new CRC32C());
    }

    void saveRowIdAndBinaryRow(RowId rowId, BinaryRow row) throws IOException {
        this.buffer.write(this.rowIdBuffer(rowId));
        ByteBuffer rowBuffer = this.rowUpgrader.upgradeByteBuffer(row);
        assert (rowBuffer.get(rowBuffer.position()) != 24) : "Tombstone header is not allowed to be saved as a data row";
        this.buffer.write(rowBuffer);
        ++this.rowsWritten;
    }

    void saveTombstone(RowId rowId) throws IOException {
        this.buffer.write(this.rowIdBuffer(rowId));
        this.buffer.write(ByteBuffer.wrap(TOMBSTONE_HEADER_BYTES));
        ++this.rowsWritten;
    }

    private ByteBuffer rowIdBuffer(RowId rowId) {
        return this.rowIdBuffer.rewind().putLong(rowId.mostSignificantBits()).putLong(rowId.leastSignificantBits()).rewind();
    }

    long rowsWritten() {
        return this.rowsWritten;
    }

    public void close() throws Exception {
        this.buffer.close();
        this.channel.close();
    }
}

