/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.jetbrains.annotations.Nullable;

public abstract class LocalSnapshotStateListener
implements WatchListener {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotManager.class);
    protected final SnapshotManagerContext context;
    private final SnapshotCoordinatorState snapshotCoordinatorState;
    private final UUID operationId;
    private final Set<String> expectedNodeNames;
    private final AtomicBoolean completed = new AtomicBoolean(false);

    LocalSnapshotStateListener(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState, UUID operationId, Set<String> expectedNodeNames) {
        this.context = context;
        this.snapshotCoordinatorState = snapshotCoordinatorState;
        this.operationId = operationId;
        this.expectedNodeNames = ConcurrentHashMap.newKeySet(IgniteUtils.capacity((int)expectedNodeNames.size()));
        this.expectedNodeNames.addAll(expectedNodeNames);
        snapshotCoordinatorState.onSnapshotOperationStarted(operationId, this);
    }

    protected abstract String nodeNameFromKey(byte[] var1);

    final Set<String> expectedNodeNames() {
        return this.expectedNodeNames;
    }

    public final CompletableFuture<Void> onUpdate(WatchEvent event) {
        Collection entryEvents = event.entryEvents();
        if (entryEvents.size() > 1) {
            assert (entryEvents.stream().allMatch(e -> e.newEntry().tombstone())) : entryEvents;
            this.context.metaStorageManager().unregisterWatch((WatchListener)this);
            return CompletableFutures.nullCompletedFuture();
        }
        Entry entry = event.entryEvent().newEntry();
        String nodeName = this.nodeNameFromKey(entry.key());
        byte[] stateBytes = entry.value();
        assert (stateBytes != null);
        LocalSnapshotState localState = LocalSnapshotStateSerializer.deserialize(stateBytes);
        this.onSnapshotStateUpdate(nodeName, localState).whenComplete((v, e) -> {
            if (e != null) {
                LOG.error("Error when handling Local State update from node {}: {}", e, new Object[]{nodeName, localState});
            }
        });
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> onSnapshotStateUpdate(String nodeName, LocalSnapshotState newState) {
        if (this.expectedNodeNames.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        SnapshotStatus status = newState.status();
        LOG.info("Snapshot operation {} update from node {} with status {}", new Object[]{this.operationId, nodeName, status});
        if (status == SnapshotStatus.STARTED) {
            return CompletableFutures.nullCompletedFuture();
        }
        boolean removed = this.expectedNodeNames.remove(nodeName);
        if (!removed) {
            return CompletableFutures.nullCompletedFuture();
        }
        switch (status) {
            case COMPLETED: {
                return this.onSnapshotComplete(nodeName);
            }
            case FAILED: {
                return this.onSnapshotFailed(nodeName, newState.errorMessage());
            }
        }
        return CompletableFuture.failedFuture((Throwable)((Object)new AssertionError((Object)("Unexpected status: " + status))));
    }

    final CompletableFuture<Void> onSnapshotComplete(String nodeName) {
        if (!this.expectedNodeNames.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!this.completed.compareAndSet(false, true)) {
            LOG.warn("Snapshot operation {} has been already completed", new Object[]{this.operationId});
            return CompletableFutures.nullCompletedFuture();
        }
        LOG.info("Snapshot operation {} complete", new Object[]{this.operationId});
        this.context.metaStorageManager().unregisterWatch((WatchListener)this);
        return this.onSnapshotCompleteImpl(this.operationId, nodeName).thenCompose(this::transitionToTerminalState);
    }

    protected abstract CompletableFuture<List<Operation>> onSnapshotCompleteImpl(UUID var1, String var2);

    final void cancel() {
        if (!this.completed.compareAndSet(false, true)) {
            LOG.warn("Snapshot operation {} has been already completed", new Object[]{this.operationId});
            return;
        }
        this.expectedNodeNames.clear();
        LOG.info("Snapshot operation {} canceled", new Object[]{this.operationId});
        this.context.metaStorageManager().unregisterWatch((WatchListener)this);
    }

    final CompletableFuture<Void> onSnapshotFailed(String nodeName, @Nullable String errorMessage) {
        if (!this.completed.compareAndSet(false, true)) {
            LOG.warn("Snapshot operation {} has been already completed", new Object[]{this.operationId});
            return CompletableFutures.nullCompletedFuture();
        }
        this.expectedNodeNames.clear();
        String description = String.format("Snapshot process failed on node \"%s\": %s", nodeName, errorMessage);
        LOG.info("Snapshot operation {} failed, reason: {}", new Object[]{this.operationId, description});
        this.context.metaStorageManager().unregisterWatch((WatchListener)this);
        return this.onSnapshotFailedImpl(this.operationId, nodeName, description).thenCompose(this::transitionToTerminalState);
    }

    protected abstract CompletableFuture<List<Operation>> onSnapshotFailedImpl(UUID var1, String var2, String var3);

    private CompletableFuture<Void> transitionToTerminalState(List<Operation> operations) {
        ByteArray coordinatorTermKey = MetaStorageKeys.coordinatorTermKey(this.operationId);
        byte[] termBytes = ByteUtils.longToBytesKeepingOrder((long)this.snapshotCoordinatorState.term());
        ArrayList<Operation> operationsWithTermUpdate = new ArrayList<Operation>(operations);
        operationsWithTermUpdate.add(Operations.put((ByteArray)coordinatorTermKey, (byte[])termBytes));
        return this.context.metaStorageManager().invoke((Condition)Conditions.value((ByteArray)coordinatorTermKey).le(termBytes), operationsWithTermUpdate, List.of()).handle((success, e) -> {
            if (e != null) {
                LOG.error("Unable to complete Snapshot {}", e, new Object[]{this.operationId});
            } else if (success.booleanValue()) {
                this.snapshotCoordinatorState.onSnapshotOperationComplete(this.operationId);
            } else {
                LOG.info("Snapshot Coordinator has changed, Snapshot process will be completed by the new Coordinator.", new Object[0]);
            }
            return null;
        });
    }
}

