/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.util.CollectionUtils;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.coordinator.DeleteSnapshotLocalStateWatch;
import org.gridgain.internal.snapshots.coordinator.RecoverySubscriber;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.coordinator.SnapshotOperations;

class DeleteSnapshotRecoveryHandler
extends RecoverySubscriber {
    private static final IgniteLogger LOG = Loggers.forClass(DeleteSnapshotRecoveryHandler.class);
    private final SnapshotCoordinatorState snapshotCoordinatorState;
    private final SnapshotOperations snapshotOperations;

    DeleteSnapshotRecoveryHandler(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState) {
        super(context);
        this.snapshotCoordinatorState = snapshotCoordinatorState;
        this.snapshotOperations = new SnapshotOperations(context);
    }

    @Override
    public void onNext(Entry entry) {
        DeleteSnapshotGlobalState globalState = DeleteSnapshotGlobalStateSerializer.deserialize(entry.value());
        if (this.snapshotCoordinatorState.hasOngoingSnapshotOperation(globalState.operationId())) {
            return;
        }
        switch (globalState.status()) {
            case COMPLETED: 
            case FAILED: {
                break;
            }
            case PREPARED: {
                LOG.error("Can not recover Delete Snapshot Operation from {} status, there is no such stage in process. Operation ID {}, Snapshot ID {}", new Object[]{globalState.status(), globalState.operationId(), globalState.targetSnapshotId()});
                break;
            }
            case STARTED: {
                this.performRecovery(globalState);
                break;
            }
            default: {
                LOG.error("Unexpected Snapshot Status: {}", new Object[]{globalState.status()});
            }
        }
    }

    private void performRecovery(DeleteSnapshotGlobalState globalState) {
        LOG.info("Starting Snapshot Deletion recovery for Snapshot Operation, current state: {}", new Object[]{globalState});
        this.snapshotOperations.removeFromParentSnapshotDependencies(globalState.parentSnapshotId(), globalState.targetSnapshotId());
        CompletableFuture logicalTopologyFuture = this.context.logicalTopologyService().logicalTopologyOnLeader();
        DeleteSnapshotLocalStateWatch localStateWatch = new DeleteSnapshotLocalStateWatch(this.context, this.snapshotCoordinatorState, globalState);
        ((CompletableFuture)logicalTopologyFuture.thenComposeAsync(topology -> {
            Set topologyNodes = topology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            Set<String> snapshotNodes = globalState.nodeNames();
            Set missingNodes = CollectionUtils.difference(snapshotNodes, topologyNodes);
            if (!missingNodes.isEmpty()) {
                LOG.info("Nodes {} are no longer present in the topology, cancelling Snapshot Operation {}", new Object[]{missingNodes, globalState.operationId()});
                String errorMessage = "Some nodes are missing from the topology: " + missingNodes;
                return localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
            return this.replayEvents(globalState, localStateWatch);
        }, (Executor)this.context.threadPool())).whenComplete((v, e) -> {
            if (e == null) {
                LOG.info("Recovery complete for Snapshot Operation {}.", new Object[]{globalState.operationId()});
            } else {
                String errorMessage = String.format("Error when performing recovery for Snapshot Operation %s: %s", globalState.operationId(), e.getMessage());
                LOG.error(errorMessage, e);
                localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
        });
    }

    private CompletableFuture<Void> replayEvents(DeleteSnapshotGlobalState globalState, DeleteSnapshotLocalStateWatch localStateWatch) {
        ByteArray prefix = MetaStorageKeys.deleteSnapshotLocalStatePrefix(globalState.targetSnapshotId());
        this.context.metaStorageManager().registerPrefixWatch(prefix, (WatchListener)localStateWatch);
        return this.replayEvents(localStateWatch, prefix);
    }
}

