/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.lang.ByteArray;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;

public enum OperationType {
    CREATE(MetaStorageKeys.createSnapshotGlobalStatePrefix(), MetaStorageKeys::createSnapshotLocalStatePrefix, OperationType::createSnapshotGlobalStateKeyFromOperationId, MetaStorageKeys::nodeNameFromCreateLocalStateKey){

        @Override
        public <T> T deserialize(byte[] bytes) {
            return (T)CreateSnapshotGlobalStateSerializer.deserialize(bytes);
        }
    }
    ,
    RESTORE(MetaStorageKeys.restoreSnapshotGlobalStatePrefix(), MetaStorageKeys::restoreSnapshotLocalStatePrefix, MetaStorageKeys::restoreSnapshotGlobalStateKey, MetaStorageKeys::nodeNameFromRestoreLocalStateKey){

        @Override
        public <T> T deserialize(byte[] bytes) {
            return (T)RestoreSnapshotGlobalStateSerializer.deserialize(bytes);
        }
    }
    ,
    DELETE(MetaStorageKeys.deleteSnapshotGlobalStatePrefix(), MetaStorageKeys::deleteSnapshotLocalStatePrefix, MetaStorageKeys::deleteSnapshotGlobalStateKey, MetaStorageKeys::nodeNameFromDeleteLocalStateKey){

        @Override
        public <T> T deserialize(byte[] bytes) {
            return (T)DeleteSnapshotGlobalStateSerializer.deserialize(bytes);
        }
    };

    private final String metastorageGlobalPrefix;
    private final Function<UUID, ByteArray> metastorageLocalPrefixFunction;
    private final Function<UUID, ByteArray> metastorageGlobalKeyFunction;
    private final Function<byte[], String> nodeNameFunction;

    private OperationType(ByteArray metastorageGlobalPrefix, Function<UUID, ByteArray> metastorageLocalStatePrefix, Function<UUID, ByteArray> metastorageGlobalKeyFunction, Function<byte[], String> nodeNameFunction) {
        this.metastorageGlobalPrefix = metastorageGlobalPrefix.toString();
        this.metastorageLocalPrefixFunction = metastorageLocalStatePrefix;
        this.metastorageGlobalKeyFunction = metastorageGlobalKeyFunction;
        this.nodeNameFunction = nodeNameFunction;
    }

    public abstract <T> T deserialize(byte[] var1);

    public ByteArray metastorageGlobalPrefix() {
        return ByteArray.fromString((String)this.metastorageGlobalPrefix);
    }

    public ByteArray metastorageLocalPrefix(UUID operationId) {
        return this.metastorageLocalPrefixFunction.apply(operationId);
    }

    public ByteArray metastorageGlobalKey(UUID operationId) {
        return this.metastorageGlobalKeyFunction.apply(operationId);
    }

    public String nodeName(byte[] localStateKey) {
        return this.nodeNameFunction.apply(localStateKey);
    }

    private static ByteArray createSnapshotGlobalStateKeyFromOperationId(UUID operationId) {
        UUID snapshotId = operationId;
        return MetaStorageKeys.createSnapshotGlobalStateKey(snapshotId);
    }
}

