/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;

public class GlobalSnapshotState {
    private final SnapshotStatus status;
    @IgniteToStringInclude
    private final Set<String> nodeNames;
    private final Instant startTime;
    private final String description;
    private final UUID operationId;
    private final SnapshotUri snapshotUri;

    GlobalSnapshotState(UUID operationId, SnapshotStatus status, Set<String> nodeNames, Instant startTime, String description, SnapshotUri snapshotUri) {
        this.operationId = operationId;
        this.status = status;
        this.nodeNames = Set.copyOf(nodeNames);
        this.startTime = startTime;
        this.description = description;
        this.snapshotUri = snapshotUri;
    }

    public UUID operationId() {
        return this.operationId;
    }

    public SnapshotStatus status() {
        return this.status;
    }

    public Set<String> nodeNames() {
        return this.nodeNames;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public String description() {
        return this.description;
    }

    public Set<QualifiedName> tableNames() {
        return Set.of();
    }

    public Set<Integer> structureIds() {
        return Set.of();
    }

    public SnapshotUri snapshotUri() {
        return this.snapshotUri;
    }

    public String toString() {
        return S.toString(GlobalSnapshotState.class, (Object)this);
    }
}

