/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.UpdateProducer;
import org.apache.ignite.internal.catalog.commands.RenameTableCommand;
import org.apache.ignite.internal.catalog.commands.RenameTableCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.storage.AlterSequenceEntry;
import org.apache.ignite.internal.catalog.storage.NewMapEntry;
import org.apache.ignite.internal.catalog.storage.NewSequenceEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.MapDescriptorView;
import org.gridgain.internal.snapshots.meta.SequenceDescriptorView;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.jetbrains.annotations.Nullable;

public class CreateStructuresCommand
implements CatalogCommand {
    private final SnapshotMeta snapshotMeta;

    public CreateStructuresCommand(SnapshotMeta snapshotMeta) {
        this.snapshotMeta = snapshotMeta;
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        this.createStructures(this.snapshotMeta.structureDescriptors(), commandState);
        return commandState.updateEntries();
    }

    private void createStructures(@Nullable Collection<? extends StructureView> views, CommandState commandState) {
        if (views == null || views.isEmpty()) {
            return;
        }
        int nextGeneratedStructureId = commandState.catalog().objectIdGenState() + 1;
        for (StructureView structureView : views) {
            Catalog catalog = commandState.catalog();
            int tableId = catalog.table("SYSTEM", structureView.tableName()).id();
            int schemaId = catalog.schema(structureView.schemaName()).id();
            if (structureView instanceof MapDescriptorView) {
                CatalogMapDescriptor descriptor = this.createMapDescriptor((MapDescriptorView)structureView, nextGeneratedStructureId, schemaId, tableId);
                commandState.applyCommand((UpdateEntry)new NewMapEntry(descriptor));
                CreateStructuresCommand.renameTable(commandState, structureView, "MAP_" + nextGeneratedStructureId);
                ++nextGeneratedStructureId;
                continue;
            }
            if (!(structureView instanceof SequenceDescriptorView)) continue;
            CatalogSequenceDescriptor existingSequence = catalog.sequence(structureView.schemaName(), structureView.name());
            CatalogSequenceDescriptor descriptor = this.createSequenceDescriptor((SequenceDescriptorView)structureView, existingSequence == null ? nextGeneratedStructureId : existingSequence.id(), schemaId, tableId);
            if (existingSequence != null) {
                commandState.applyCommand((UpdateEntry)new AlterSequenceEntry(descriptor));
            } else {
                commandState.applyCommand((UpdateEntry)new NewSequenceEntry(descriptor));
                ++nextGeneratedStructureId;
            }
            CreateStructuresCommand.renameTable(commandState, structureView, "SEQ_" + nextGeneratedStructureId);
        }
        commandState.applyCommand((UpdateEntry)new ObjectIdGenUpdateEntry(views.size()));
    }

    private static void renameTable(CommandState commandState, StructureView view, String newName) {
        commandState.applyCommand((UpdateProducer)((RenameTableCommandBuilder)((RenameTableCommandBuilder)RenameTableCommand.builder().schemaName("SYSTEM")).tableName(view.tableName())).newTableName(newName).validateSystemSchemas(false).build());
    }

    private CatalogSequenceDescriptor createSequenceDescriptor(SequenceDescriptorView sequenceView, int id, int schemaId, int tableId) {
        return new CatalogSequenceDescriptor(id, tableId, schemaId, sequenceView.name(), sequenceView.increment(), sequenceView.minvalue(), sequenceView.maxvalue(), sequenceView.start(), sequenceView.cache());
    }

    private CatalogMapDescriptor createMapDescriptor(MapDescriptorView mapView, int id, int schemaId, int tableId) {
        return new CatalogMapDescriptor(id, tableId, schemaId, mapView.name());
    }
}

