/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotMetaNotFoundException;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;

public class SnapshotMetaSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).registerModule((Module)new JavaTimeModule());

    /*
     * Enabled aggressive exception aggregation
     */
    public SnapshotMeta readSnapshotMeta(SnapshotFileSystem fileSystem) {
        SnapshotMetaPath snapshotMeta = fileSystem.snapshotMeta();
        try (ReadableByteChannel channel = snapshotMeta.readChannel();){
            SnapshotMeta snapshotMeta2;
            block15: {
                Reader reader = Channels.newReader(channel, StandardCharsets.UTF_8);
                try {
                    snapshotMeta2 = (SnapshotMeta)OBJECT_MAPPER.readValue(reader, SnapshotMeta.class);
                    if (reader == null) break block15;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return snapshotMeta2;
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMetaNotFoundException(fileSystem.snapshotId(), snapshotMeta.uri());
        }
        catch (IOException e) {
            throw new SnapshotException(String.format("Error when reading Snapshot Meta of Snapshot %s: %s.", snapshotMeta.uri(), e), e);
        }
    }

    public void writeSnapshotMeta(SnapshotMeta snapshotMeta, SnapshotFileSystem snapshotFileSystem) {
        try (WritableByteChannel channel = snapshotFileSystem.snapshotMeta().writeChannel();
             Writer writer = Channels.newWriter(channel, StandardCharsets.UTF_8);){
            OBJECT_MAPPER.writeValue(writer, (Object)snapshotMeta);
        }
        catch (IOException e) {
            throw new SnapshotException(String.format("Error when writing Snapshot Meta of Snapshot %s: %s.", snapshotMeta.snapshotId(), e), e);
        }
    }
}

