/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.snapshots.OngoingSnapshotOperations;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotMetaSerializer;
import org.gridgain.internal.snapshots.SnapshotProperties;
import org.gridgain.internal.snapshots.configuration.NodeSnapshotConfiguration;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.meta.SnapshotMetaWriter;
import org.gridgain.internal.snapshots.signature.SnapshotSignatureSerializer;
import org.gridgain.internal.snapshots.tombstone.SnapshotTombstoneManager;

public class SnapshotManagerContext
implements ManuallyCloseable {
    private final ClusterService clusterService;
    private final MetaStorageManagerImpl metaStorageManager;
    private final CatalogManager catalogManager;
    private final ReplicaManager replicaManager;
    private final TableManager tableManager;
    private final TxManager txManager;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final LogicalTopologyService logicalTopologyService;
    private final SchemaSyncService schemaSyncService;
    private final PlacementDriver placementDriver;
    private final HybridClock clock;
    private final ThreadPoolExecutor threadPool;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final SnapshotFileSystemManager snapshotFileSystemManager;
    private final SnapshotMetaSerializer snapshotMetaSerializer;
    private final SnapshotMetaWriter snapshotMetaWriter;
    private final ReplicationConfiguration replicationConfiguration;
    private final SnapshotTombstoneManager snapshotTombstoneManager;
    private final OngoingSnapshotOperations ongoingSnapshotOperations = new OngoingSnapshotOperations();
    private final DataEncryptionKeyManager keyManager;
    private final NodeProperties nodeProperties;
    private final SnapshotProperties properties;
    private final ClockService clockService;

    SnapshotManagerContext(ClusterService clusterService, MetaStorageManagerImpl metaStorageManager, CatalogManager catalogManager, ReplicaManager replicaManager, TableManager tableManager, TxManager txManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, LogicalTopologyService logicalTopologyService, SchemaSyncService schemaSyncService, PlacementDriver placementDriver, HybridClock clock, SnapshotFileSystemManager snapshotFileSystemManager, NodeSnapshotConfiguration snapshotConfiguration, ReplicationConfiguration replicationConfiguration, SnapshotTombstoneManager snapshotTombstoneManager, EncryptionManager encryptionManager, DataEncryptionKeyManager keyManager, NodeProperties nodeProperties, SystemLocalConfiguration systemLocalConfiguration, ClockService clockService) {
        this.clusterService = clusterService;
        this.metaStorageManager = metaStorageManager;
        this.catalogManager = catalogManager;
        this.replicaManager = replicaManager;
        this.tableManager = tableManager;
        this.txManager = txManager;
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.logicalTopologyService = logicalTopologyService;
        this.schemaSyncService = schemaSyncService;
        this.placementDriver = placementDriver;
        this.clock = clock;
        this.replicationConfiguration = replicationConfiguration;
        this.snapshotFileSystemManager = snapshotFileSystemManager;
        this.snapshotTombstoneManager = snapshotTombstoneManager;
        this.keyManager = keyManager;
        this.nodeProperties = nodeProperties;
        this.clockService = clockService;
        int threadPoolSize = (Integer)snapshotConfiguration.threadPoolSize().value();
        this.threadPool = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)clusterService.nodeName(), (String)"gg-snapshots", (IgniteLogger)Loggers.forClass(SnapshotManager.class), (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.threadPool.allowCoreThreadTimeOut(true);
        this.snapshotMetaSerializer = new SnapshotMetaSerializer();
        this.snapshotMetaWriter = new SnapshotMetaWriter(catalogManager, snapshotFileSystemManager, this.snapshotMetaSerializer, new SnapshotSignatureSerializer(encryptionManager), this.threadPool, (Integer)snapshotConfiguration.snapshotChunkSizeBytes().value());
        this.properties = new SnapshotProperties(systemLocalConfiguration);
    }

    public String nodeName() {
        return this.clusterService.nodeName();
    }

    public MessagingService messagingService() {
        return this.clusterService.messagingService();
    }

    public TopologyService topologyService() {
        return this.clusterService.topologyService();
    }

    public MetaStorageManagerImpl metaStorageManager() {
        return this.metaStorageManager;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public TableManager tableManager() {
        return this.tableManager;
    }

    public TxManager txManager() {
        return this.txManager;
    }

    public PartitionReplicaLifecycleManager partitionReplicaLifecycleManager() {
        return this.partitionReplicaLifecycleManager;
    }

    public LogicalTopologyService logicalTopologyService() {
        return this.logicalTopologyService;
    }

    public SchemaSyncService schemaSyncService() {
        return this.schemaSyncService;
    }

    public PlacementDriver placementDriver() {
        return this.placementDriver;
    }

    public HybridClock clock() {
        return this.clock;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public IgniteSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public SnapshotFileSystemManager snapshotFileSystemManager() {
        return this.snapshotFileSystemManager;
    }

    public SnapshotMetaSerializer snapshotMetaSerializer() {
        return this.snapshotMetaSerializer;
    }

    public SnapshotMetaWriter snapshotMetaWriter() {
        return this.snapshotMetaWriter;
    }

    public ReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    public SnapshotTombstoneManager snapshotTombstoneManager() {
        return this.snapshotTombstoneManager;
    }

    public OngoingSnapshotOperations ongoingSnapshots() {
        return this.ongoingSnapshotOperations;
    }

    public DataEncryptionKeyManager keyManager() {
        return this.keyManager;
    }

    public NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public SnapshotProperties properties() {
        return this.properties;
    }

    public ClockService clockService() {
        return this.clockService;
    }

    public void close() throws Exception {
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }
}

