/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;

class EncryptedWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel channel;
    private final DisposableByteBuffer disposableBuffer;
    private final SnapshotEncryptor encryptor;

    EncryptedWritableByteChannel(SnapshotEncryptor encryptor, WritableByteChannel channel, DisposableByteBuffer disposableBuffer) {
        this.disposableBuffer = disposableBuffer;
        this.channel = channel;
        this.encryptor = encryptor;
    }

    private ByteBuffer buffer() {
        return this.disposableBuffer.buffer();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer = this.buffer();
        buffer.rewind();
        int startPos = src.position();
        this.encryptor.encrypt(src, buffer);
        buffer.flip();
        while (buffer.remaining() > 0) {
            this.channel.write(buffer);
        }
        return src.position() - startPos;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.disposableBuffer.dispose();
    }
}

