/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.lang.GridgainErrorGroups;

public class SnapshotUtils {
    public static void filterTables(SnapshotMeta snapshotMeta, Set<QualifiedName> tableNames) {
        if (tableNames.isEmpty()) {
            return;
        }
        snapshotMeta.tableSnapshotMetas().removeIf(table -> {
            TableDescriptorView tableDescriptor = table.schema().tableDescriptor();
            QualifiedName fullTableName = QualifiedNameHelper.fromNormalized((String)tableDescriptor.schemaName(), (String)tableDescriptor.name());
            return !tableNames.contains(fullTableName);
        });
    }

    public static boolean isMissing(Entry entry) {
        return entry == null || entry.value() == null;
    }

    public static List<CatalogTableDescriptor> tempTableDescriptors(SnapshotMeta snapshotMeta, UUID operationId, Catalog catalog) {
        String tmpPrefix = SnapshotManager.tmpTableNamePrefix(operationId);
        return snapshotMeta.tableSnapshotMetas().stream().map(tableMeta -> tableMeta.schema().tableDescriptor()).map(tableDescriptor -> {
            String tmpName = tmpPrefix + tableDescriptor.name();
            return catalog.table(tableDescriptor.schemaName(), tmpName);
        }).collect(Collectors.toList());
    }

    public static CompletableFuture<Void> awaitPrimaryReplicas(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        return context.nodeProperties().colocationEnabled() ? SnapshotUtils.awaitPrimaryReplicasForZones(context, tableDescriptors, catalog) : SnapshotUtils.awaitPrimaryReplicasForTables(context, tableDescriptors, catalog);
    }

    private static CompletableFuture<Void> awaitPrimaryReplicasForTables(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        HybridTimestamp now = context.clock().now();
        CompletableFuture[] awaitFutures = (CompletableFuture[])tableDescriptors.stream().flatMap(tableDescriptor -> {
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(tableDescriptor.zoneId());
            assert (zoneDescriptor != null) : "Zone descriptor is null for zone ID: " + tableDescriptor.zoneId();
            int tableId = tableDescriptor.id();
            String tableName = tableDescriptor.name();
            return IntStream.range(0, zoneDescriptor.partitions()).mapToObj(partId -> new TablePartitionId(tableId, partId)).map(tablePartitionId -> SnapshotUtils.awaitPrimaryReplica(context, (PartitionGroupId)tablePartitionId, tableName, now, false));
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(awaitFutures);
    }

    private static CompletableFuture<Void> awaitPrimaryReplicasForZones(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        HybridTimestamp now = context.clock().now();
        CompletableFuture[] awaitFutures = (CompletableFuture[])tableDescriptors.stream().map(CatalogTableDescriptor::zoneId).distinct().flatMap(zoneId -> {
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneId.intValue());
            assert (zoneDescriptor != null) : "Zone descriptor is null for zone ID: " + zoneId;
            String zoneName = zoneDescriptor.name();
            return IntStream.range(0, zoneDescriptor.partitions()).mapToObj(partId -> new ZonePartitionId(zoneId.intValue(), partId)).map(zonePartitionId -> SnapshotUtils.awaitPrimaryReplica(context, (PartitionGroupId)zonePartitionId, zoneName, now, true));
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(awaitFutures);
    }

    private static CompletableFuture<?> awaitPrimaryReplica(SnapshotManagerContext context, PartitionGroupId partitionId, String objectName, HybridTimestamp timestamp, boolean colocationEnabled) {
        int timeout = context.properties().awaitPrimaryReplicaTimeoutSeconds();
        return context.placementDriver().awaitPrimaryReplica((ReplicationGroupId)partitionId, timestamp, (long)timeout, TimeUnit.SECONDS).exceptionally(e -> {
            if ((e = ExceptionUtils.unwrapCause((Throwable)e)) instanceof PrimaryReplicaAwaitTimeoutException) {
                if (colocationEnabled) {
                    int zoneId = partitionId.objectId();
                    throw new SnapshotException(GridgainErrorGroups.Snapshots.SNAPSHOT_REPLICA_TIMEOUT_ERR, String.format("Timed out while waiting for the primary replica to appear. Zone [zoneId=%d zoneName=%s] can be under rebalance or has empty data nodes or the cluster has lost majority for one of its partitions.", zoneId, objectName), (Throwable)e);
                }
                int tableId = partitionId.objectId();
                throw new SnapshotException(GridgainErrorGroups.Snapshots.SNAPSHOT_REPLICA_TIMEOUT_ERR, String.format("Timed out while waiting for the primary replica to appear. Table [tableId=%d tableName=%s] is under rebalance or belongs to a zone with empty data nodes or the cluster has lost majority for one of its partitions.", tableId, objectName), (Throwable)e);
            }
            throw new SnapshotException(String.format("Internal error while waiting for primary replica [partitionId=%s, objectName=%s].", partitionId, objectName), (Throwable)e);
        });
    }
}

