/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogApplyResult;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotIllegalArgumentException;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotUtils;
import org.gridgain.internal.snapshots.catalog.CreateTemporaryTablesCommand;
import org.gridgain.internal.snapshots.catalog.SwitchTablesAccessCommand;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.RestoreSnapshotLocalStateWatch;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;

class SnapshotRestorationProcess {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotManager.class);
    private final SnapshotManagerContext context;
    private final SnapshotCoordinatorState snapshotCoordinatorState;

    SnapshotRestorationProcess(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState) {
        this.context = context;
        this.snapshotCoordinatorState = snapshotCoordinatorState;
    }

    CompletableFuture<Void> prepareSnapshotRestoration(RestoreSnapshotGlobalState preparedState) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            SnapshotFileSystem snapshotFileSystem = this.context.snapshotFileSystemManager().snapshotFileSystem(preparedState.targetSnapshotId(), preparedState.snapshotUri());
            SnapshotMeta snapshotMeta = this.context.snapshotMetaSerializer().readSnapshotMeta(snapshotFileSystem);
            Set<QualifiedName> tableNames = preparedState.tableNames();
            SnapshotUtils.filterTables(snapshotMeta, tableNames);
            Set<QualifiedName> metaTableNames = snapshotMeta.tableSnapshotMetas().stream().map(table -> QualifiedNameHelper.fromNormalized((String)table.schema().tableDescriptor().schemaName(), (String)table.schema().tableDescriptor().name())).collect(Collectors.toSet());
            if (!tableNames.isEmpty() && metaTableNames.size() < tableNames.size()) {
                List missingTables = CollectionUtils.difference(tableNames, metaTableNames).stream().map(QualifiedName::toCanonicalForm).sorted().collect(Collectors.toList());
                return CompletableFuture.failedFuture((Throwable)((Object)new SnapshotIllegalArgumentException(String.format("Unable to restore snapshot %s. Some tables are missing from the target snapshot: %s", preparedState.targetSnapshotId(), missingTables))));
            }
            RestoreSnapshotGlobalState state = tableNames.isEmpty() ? new RestoreSnapshotGlobalState(preparedState.operationId(), preparedState.status(), preparedState.nodeNames(), metaTableNames, preparedState.targetSnapshotId(), preparedState.catalogVersion(), preparedState.startTime(), preparedState.description(), preparedState.snapshotUri(), preparedState.encryptionProviderName()) : preparedState;
            CompletableFuture<Void> preparedStateInitFuture = this.initPreparedState(state);
            preparedStateInitFuture.thenComposeAsync(v -> {
                RestoreSnapshotLocalStateWatch localStateWatch = new RestoreSnapshotLocalStateWatch(this.context, this.snapshotCoordinatorState, state, snapshotMeta);
                return this.startSnapshotRestoration(localStateWatch, state);
            }, (Executor)this.context.threadPool());
            return preparedStateInitFuture;
        });
    }

    private CompletableFuture<Void> initPreparedState(RestoreSnapshotGlobalState state) {
        UUID snapshotId = state.targetSnapshotId();
        ByteArray restoreLockKey = MetaStorageKeys.restoreSnapshotLockKey();
        Condition condition = Conditions.notExists((ByteArray)restoreLockKey).and((Condition)Conditions.notExists((ByteArray)MetaStorageKeys.deleteSnapshotLockKey(snapshotId)));
        List<Operation> operations = List.of(Operations.put((ByteArray)MetaStorageKeys.restoreSnapshotGlobalStateKey(state.operationId()), (byte[])RestoreSnapshotGlobalStateSerializer.serialize(state)), Operations.put((ByteArray)MetaStorageKeys.coordinatorTermKey(state.operationId()), (byte[])ByteUtils.longToBytesKeepingOrder((long)this.snapshotCoordinatorState.term())), Operations.put((ByteArray)restoreLockKey, (byte[])ByteUtils.uuidToBytes((UUID)snapshotId)));
        return this.context.metaStorageManager().invoke(condition, operations, List.of()).thenAccept(success -> {
            if (!success.booleanValue()) {
                throw new SnapshotException(String.format("Unable to start restoration of Snapshot %s: concurrent operation detected, either another snapshot is being restored or this snapshot is about to be deleted", snapshotId));
            }
        });
    }

    CompletableFuture<Void> startSnapshotRestoration(RestoreSnapshotLocalStateWatch localStateWatch, RestoreSnapshotGlobalState preparedState) {
        UUID operationId = preparedState.operationId();
        return ((CompletableFuture)((CompletableFuture)this.lockExistingAndCreateTmpTables(operationId, localStateWatch.targetSnapshotMeta()).thenCompose(catalogVersion -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            Catalog catalog = this.context.catalogManager().catalog(catalogVersion.intValue());
            List<CatalogTableDescriptor> tmpTableDescriptors = SnapshotUtils.tempTableDescriptors(localStateWatch.targetSnapshotMeta(), operationId, catalog);
            return SnapshotUtils.awaitPrimaryReplicas(this.context, tmpTableDescriptors, catalog).thenComposeAsync(v -> {
                this.snapshotCoordinatorState.rebalanceWatch().addOperation(operationId, tmpTableDescriptors);
                LOG.info("Starting distributed restoration of snapshot {}, operation ID: {}.", new Object[]{preparedState.targetSnapshotId(), operationId});
                RestoreSnapshotGlobalState startedState = new RestoreSnapshotGlobalState(operationId, SnapshotStatus.STARTED, preparedState.nodeNames(), preparedState.tableNames(), preparedState.targetSnapshotId(), (int)catalogVersion, preparedState.startTime(), preparedState.description(), preparedState.snapshotUri(), preparedState.encryptionProviderName());
                this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.restoreSnapshotLocalStatePrefix(startedState.operationId()), (WatchListener)localStateWatch);
                ByteArray coordinatorTermKey = MetaStorageKeys.coordinatorTermKey(startedState.operationId());
                byte[] termBytes = ByteUtils.longToBytesKeepingOrder((long)this.snapshotCoordinatorState.term());
                return this.context.metaStorageManager().invoke((Condition)Conditions.value((ByteArray)coordinatorTermKey).le(termBytes), List.of(Operations.put((ByteArray)MetaStorageKeys.restoreSnapshotGlobalStateKey(startedState.operationId()), (byte[])RestoreSnapshotGlobalStateSerializer.serialize(startedState)), Operations.put((ByteArray)coordinatorTermKey, (byte[])termBytes)), List.of());
            }, (Executor)this.context.threadPool());
        }))).handle((success, e) -> {
            if (e != null) {
                LOG.error("Unable to start distributed snapshot restoration, operation ID: {}", e, new Object[]{operationId});
                return localStateWatch.onSnapshotFailed(this.context.nodeName(), e.getMessage());
            }
            if (!success.booleanValue()) {
                LOG.info("Snapshot Coordinator has changed, Snapshot process will be completed by the new Coordinator.", new Object[0]);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Integer> lockExistingAndCreateTmpTables(UUID operationId, SnapshotMeta snapshotMeta) {
        return this.context.catalogManager().execute(List.of(SwitchTablesAccessCommand.lockTables(snapshotMeta), new CreateTemporaryTablesCommand(SnapshotManager.tmpTableNamePrefix(operationId), snapshotMeta))).thenApply(CatalogApplyResult::getCatalogVersion);
    }
}

