/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;

public class RestoreSnapshotGlobalStateSerializer
extends VersionedSerializer<RestoreSnapshotGlobalState> {
    public static final RestoreSnapshotGlobalStateSerializer INSTANCE = new RestoreSnapshotGlobalStateSerializer();
    private final GlobalSnapshotStateSerializer globalSnapshotStateSerializer = GlobalSnapshotStateSerializer.INSTANCE;

    protected byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(RestoreSnapshotGlobalState state, IgniteDataOutput out) throws IOException {
        this.globalSnapshotStateSerializer.writeExternal(state, out);
        out.writeUuid(state.targetSnapshotId());
        out.writeVarInt((long)state.catalogVersion());
        RestoreSnapshotGlobalStateSerializer.writeStringSet((Set)CollectionUtils.mapToImmutableSet(state.tableNames(), QualifiedName::toCanonicalForm), (IgniteDataOutput)out);
        RestoreSnapshotGlobalStateSerializer.writeNullableString((String)state.encryptionProviderName(), (IgniteDataOutput)out);
    }

    protected RestoreSnapshotGlobalState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        GlobalSnapshotState globalState = (GlobalSnapshotState)this.globalSnapshotStateSerializer.readExternal(in);
        UUID targetSnapshotId = in.readUuid();
        int catalogVersion = in.readVarIntAsInt();
        Set tableNames = CollectionUtils.mapToImmutableSet((Set)RestoreSnapshotGlobalStateSerializer.readStringSet((IgniteDataInput)in), QualifiedName::parse);
        String encryptionProviderName = protoVer > 1 ? RestoreSnapshotGlobalStateSerializer.readNullableString((IgniteDataInput)in) : null;
        return new RestoreSnapshotGlobalState(globalState.operationId(), globalState.status(), globalState.nodeNames(), tableNames, targetSnapshotId, catalogVersion, globalState.startTime(), globalState.description(), globalState.snapshotUri(), encryptionProviderName);
    }

    public static byte[] serialize(RestoreSnapshotGlobalState state) {
        return VersionedSerialization.toBytes((Object)state, (VersionedSerializer)INSTANCE);
    }

    public static RestoreSnapshotGlobalState deserialize(byte[] bytes) {
        return (RestoreSnapshotGlobalState)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)INSTANCE);
    }
}

