/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.ReadOnlyTransactionsHelper;
import org.apache.ignite.internal.tx.TooOldTransactionException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.recovery.PartitionsCalculator;
import org.gridgain.internal.snapshots.DataKeyGenerator;
import org.gridgain.internal.snapshots.PartitionResponsibilityTrigger;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.TableSnapshotWriter;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;
import org.gridgain.internal.snapshots.signature.SnapshotSignature;

class SnapshotWriter {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotWriter.class);
    private final SnapshotManagerContext context;
    private final PartitionsCalculator partitionsCalculator;
    private final ReadOnlyTransactionsHelper transactions;

    SnapshotWriter(SnapshotManagerContext context) {
        this.context = context;
        this.partitionsCalculator = new PartitionsCalculator(context.nodeName(), (MetaStorageManager)context.metaStorageManager(), context.nodeProperties());
        this.transactions = new ReadOnlyTransactionsHelper(context.txManager());
    }

    CompletableFuture<Long> createSnapshot(SnapshotContext<CreateSnapshotGlobalState> snapshotContext) {
        return snapshotContext.inBusyLockAsync(() -> {
            HybridTimestamp tombstoneLowWatermark;
            CreateSnapshotGlobalState snapshotState = (CreateSnapshotGlobalState)snapshotContext.snapshotState();
            if (snapshotState.parentSnapshotId() != null && (tombstoneLowWatermark = this.context.snapshotTombstoneManager().addOngoingIncrementalSnapshot(snapshotState.snapshotId())).compareTo(snapshotState.fromTimestamp()) > 0) {
                return CompletableFuture.failedFuture((Throwable)((Object)new SnapshotException("Tombstones are not preserved since the last snapshot")));
            }
            return this.context.schemaSyncService().waitForMetadataCompleteness(((CreateSnapshotGlobalState)snapshotContext.snapshotState()).timestamp()).thenComposeAsync(v -> snapshotContext.inBusyLockAsync(() -> this.createSnapshotAfterSchemaSync(snapshotContext)), (Executor)this.context.threadPool());
        });
    }

    private CompletableFuture<Long> createSnapshotAfterSchemaSync(SnapshotContext<CreateSnapshotGlobalState> snapshotContext) {
        CreateSnapshotGlobalState snapshotState = snapshotContext.snapshotState();
        HybridTimestamp readTimestamp = snapshotState.fromTimestamp().equals((Object)HybridTimestamp.MIN_VALUE) ? snapshotState.timestamp() : snapshotState.fromTimestamp();
        try {
            return this.transactions.runInReadOnlyTransaction(readTimestamp, transaction -> this.createSnapshotAfterSchemaSync(snapshotContext, (InternalTransaction)transaction));
        }
        catch (TooOldTransactionException e) {
            throw new SnapshotException("Snapshot requested at timestamp which is below the current low watermark: " + e.getMessage(), e);
        }
    }

    private CompletableFuture<Long> createSnapshotAfterSchemaSync(SnapshotContext<CreateSnapshotGlobalState> snapshotContext, InternalTransaction transaction) {
        CreateSnapshotGlobalState snapshotState = snapshotContext.snapshotState();
        List<CatalogTableDescriptor> tableDescriptors = this.collectTableDescriptors(snapshotState);
        SnapshotUri snapshotUri = snapshotState.snapshotUri();
        UUID operationId = snapshotContext.operationId();
        if (LOG.isInfoEnabled()) {
            LOG.info("Snapshot creation operation {} started [snapshotUri={}, tables={}].", new Object[]{operationId, snapshotUri, tableDescriptors.stream().map(CatalogObjectDescriptor::name).collect(Collectors.toList())});
        }
        if (snapshotUri.isSingleCopy()) {
            return ((CompletableFuture)this.tryReadSharedSnapshotMeta(snapshotState.snapshotId(), snapshotUri).thenCompose(v -> this.createSingleCopyTableSnapshots(snapshotContext, tableDescriptors, transaction))).whenComplete((numRows, e) -> {
                if (e != null) {
                    LOG.error("Single copy snapshot creation operation {} failed", new Object[]{operationId, e});
                } else {
                    LOG.info("Single copy snapshot creation operation {} complete, number of rows saved by this node: {}", new Object[]{operationId, numRows});
                }
            });
        }
        SnapshotSignature signature = snapshotState.encryptionProviderName() != null ? new SnapshotSignature(this.context.keyManager().activeKey(operationId.toString()), DataKeyGenerator.defaultCipherAlgorithm()) : null;
        return ((CompletableFuture)this.createTableSnapshots(snapshotContext, tableDescriptors, transaction).thenCompose(numRows -> this.context.snapshotMetaWriter().saveSnapshotMeta(snapshotState, signature).thenApply(v -> numRows))).whenComplete((numRows, e) -> {
            this.context.keyManager().remove(operationId.toString());
            if (e != null) {
                LOG.error("Snapshot creation operation {} failed", new Object[]{operationId, e});
            } else {
                LOG.info("Snapshot creation operation {} complete, number of rows saved: {}", new Object[]{operationId, numRows});
            }
        });
    }

    private CompletableFuture<Long> createTableSnapshots(SnapshotContext<CreateSnapshotGlobalState> snapshotContext, List<CatalogTableDescriptor> tableDescriptors, InternalTransaction transaction) {
        return this.createTableSnapshotsImpl(snapshotContext, tableDescriptors, transaction, TableSnapshotWriter::createPartitionSnapshots);
    }

    private CompletableFuture<Long> createSingleCopyTableSnapshots(SnapshotContext<CreateSnapshotGlobalState> snapshotContext, List<CatalogTableDescriptor> tableDescriptors, InternalTransaction transaction) {
        PartitionResponsibilityTrigger partitionResponsibilityTrigger = new PartitionResponsibilityTrigger(this.context, this.context.topologyService().localMember().id(), snapshotContext.snapshotState().snapshotId());
        return this.createTableSnapshotsImpl(snapshotContext, tableDescriptors, transaction, tableSnapshotWriter -> tableSnapshotWriter.createSingleCopyPartitionSnapshots(partitionResponsibilityTrigger));
    }

    private CompletableFuture<Long> createTableSnapshotsImpl(SnapshotContext<CreateSnapshotGlobalState> snapshotContext, List<CatalogTableDescriptor> tableDescriptors, InternalTransaction transaction, Function<TableSnapshotWriter, CompletableFuture<Long>> createSnapshotFunction) {
        return ((CompletableFuture)this.partitionsCalculator.calculatePartitions(tableDescriptors, snapshotContext.causalityToken()).thenComposeAsync(partitions -> {
            CompletableFuture[] tableSnapshotFutures = new CompletableFuture[tableDescriptors.size()];
            for (int i = 0; i < tableDescriptors.size(); ++i) {
                CatalogTableDescriptor tableDescriptor = (CatalogTableDescriptor)tableDescriptors.get(i);
                PartitionSet partitionSet = (PartitionSet)partitions.get(this.context.nodeProperties().colocationEnabled() ? tableDescriptor.zoneId() : tableDescriptor.id());
                if (partitionSet.size() == 0) {
                    tableSnapshotFutures[i] = CompletableFuture.completedFuture(0L);
                    continue;
                }
                TableViewInternal table = this.context.tableManager().cachedTable(tableDescriptor.id());
                assert (table != null) : String.format("Table not found: id=%d", tableDescriptor.id());
                TableSnapshotWriter tableSnapshotWriter = new TableSnapshotWriter(snapshotContext, this.context.topologyService().localMember(), table, partitionSet, this.context.threadPool(), tableDescriptor.latestSchemaVersion(), transaction);
                LOG.info("Starting snapshot creation for table {} ({}).", new Object[]{tableDescriptor.name(), tableDescriptor.id()});
                tableSnapshotFutures[i] = (CompletableFuture)createSnapshotFunction.apply(tableSnapshotWriter);
            }
            return CompletableFutures.allOfToList((CompletableFuture[])tableSnapshotFutures);
        }, (Executor)this.context.threadPool())).thenApply(numRowsList -> numRowsList.stream().mapToLong(Long::longValue).sum());
    }

    private List<CatalogTableDescriptor> collectTableDescriptors(CreateSnapshotGlobalState snapshotState) {
        long timestampLong = snapshotState.timestamp().longValue();
        int catalogVersion = this.context.catalogManager().activeCatalogVersion(timestampLong);
        Catalog catalog = this.context.catalogManager().catalog(catalogVersion);
        assert (catalog != null) : "Catalog not found, version = " + catalogVersion;
        ArrayList<CatalogTableDescriptor> tableDescriptors = new ArrayList<CatalogTableDescriptor>(snapshotState.tableIds().size());
        for (Integer tableId : snapshotState.tableIds()) {
            CatalogTableDescriptor tableDescriptor = catalog.table(tableId.intValue());
            assert (tableDescriptor != null) : String.format("Table not found: id=%d, catalogVersion=%d", tableId, catalogVersion);
            tableDescriptors.add(tableDescriptor);
        }
        return tableDescriptors;
    }

    private CompletableFuture<Void> tryReadSharedSnapshotMeta(UUID snapshotId, SnapshotUri snapshotUri) {
        SnapshotMetaPath metaPath = this.context.snapshotFileSystemManager().snapshotFileSystem(snapshotId, snapshotUri).snapshotMeta();
        return CompletableFuture.runAsync(() -> {
            try {
                ReadableByteChannel readableByteChannel = metaPath.readChannel();
                readableByteChannel.close();
            }
            catch (IOException e) {
                throw new SnapshotException(String.format("Shared snapshot meta is not accessible [path=%s]", metaPath.uri()), e);
            }
        }, this.context.threadPool());
    }
}

