/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.impl.MetaStorageEvent;
import org.apache.ignite.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Lazy;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.snapshots.CreateSnapshotGlobalStateWatch;
import org.gridgain.internal.snapshots.DeleteSnapshotGlobalStateWatch;
import org.gridgain.internal.snapshots.RestoreSnapshotGlobalStateWatch;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotMessageCallback;
import org.gridgain.internal.snapshots.SnapshotMessageHandler;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.DeleteSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessageGroup;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.configuration.NodeSnapshotConfiguration;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorRole;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.tombstone.SnapshotTombstoneManager;
import org.jetbrains.annotations.TestOnly;

public class SnapshotManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotManager.class);
    private final SnapshotManagerContext context;
    private final CreateSnapshotGlobalStateWatch createSnapshotGlobalStateWatch;
    private final RestoreSnapshotGlobalStateWatch restoreSnapshotGlobalStateWatch;
    private final DeleteSnapshotGlobalStateWatch deleteSnapshotGlobalStateWatch;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final Lazy<SnapshotCoordinatorRole> snapshotCoordinatorRole;

    public SnapshotManager(ClusterService clusterService, MetaStorageManagerImpl metaStorageManager, CatalogManager catalogManager, TableManager tableManager, TxManager txManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, LogicalTopologyService logicalTopologyService, SchemaSyncService schemaSyncService, PlacementDriver placementDriver, ReplicaManager replicaManager, HybridClock clock, SnapshotFileSystemManager snapshotsFileSystem, NodeSnapshotConfiguration snapshotConfiguration, ReplicationConfiguration replicationConfiguration, SnapshotTombstoneManager snapshotTombstoneManager, EncryptionManager encryptionManager, DataEncryptionKeyManager dataEncryptionKeyManager, NodeProperties nodeProperties, SystemLocalConfiguration systemLocalConfiguration, ClockService clockService) {
        this.context = new SnapshotManagerContext(clusterService, metaStorageManager, catalogManager, replicaManager, tableManager, txManager, partitionReplicaLifecycleManager, logicalTopologyService, schemaSyncService, placementDriver, clock, snapshotsFileSystem, snapshotConfiguration, replicationConfiguration, snapshotTombstoneManager, encryptionManager, dataEncryptionKeyManager, nodeProperties, systemLocalConfiguration, clockService);
        this.createSnapshotGlobalStateWatch = new CreateSnapshotGlobalStateWatch(this.context);
        this.restoreSnapshotGlobalStateWatch = new RestoreSnapshotGlobalStateWatch(this.context);
        this.deleteSnapshotGlobalStateWatch = new DeleteSnapshotGlobalStateWatch(this.context);
        this.snapshotCoordinatorRole = new Lazy(() -> new SnapshotCoordinatorRole(this.context));
        metaStorageManager.listen((Event)MetaStorageEvent.ON_LEADER_ELECTED, parameters -> ((SnapshotCoordinatorRole)this.snapshotCoordinatorRole.get()).onBecomeCoordinator(parameters.term()).thenApply(ignored -> true));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.context.messagingService().addMessageHandler(SnapshotMessageGroup.class, (NetworkMessageHandler)new SnapshotMessageHandler(this.context, new SnapshotMessageCallback(){

            @Override
            public CompletableFuture<UUID> onCreateSnapshotMessageReceived(long term, CreateSnapshotMessage message) {
                return SnapshotManager.this.startSnapshotCreation(term, message);
            }

            @Override
            public CompletableFuture<UUID> onRestoreSnapshotMessageReceived(long term, RestoreSnapshotMessage message) {
                return SnapshotManager.this.prepareSnapshotRestoration(term, message);
            }

            @Override
            public CompletableFuture<UUID> onDeleteSnapshotMessageReceived(long term, DeleteSnapshotMessage message) {
                return SnapshotManager.this.prepareSnapshotDeletion(term, message);
            }
        }));
        this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.createSnapshotGlobalStatePrefix(), (WatchListener)this.createSnapshotGlobalStateWatch);
        this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.restoreSnapshotGlobalStatePrefix(), (WatchListener)this.restoreSnapshotGlobalStateWatch);
        this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.deleteSnapshotGlobalStatePrefix(), (WatchListener)this.deleteSnapshotGlobalStateWatch);
        return CompletableFutures.nullCompletedFuture();
    }

    public void beforeNodeStop() {
        try {
            this.context.ongoingSnapshots().cancelAllSnapshotsOperationsDueToLocalFailure().get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            LOG.error("Exception while waiting for snapshot cancellation", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for snapshot cancellation", new Object[0]);
        }
        catch (TimeoutException e) {
            LOG.error("Timeout while waiting for snapshot cancellation", new Object[0]);
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            this.context.close();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public static String tmpTableNamePrefix(UUID operationId) {
        return operationId + "_";
    }

    private CompletableFuture<UUID> startSnapshotCreation(long term, CreateSnapshotMessage message) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            LOG.info("CREATE SNAPSHOT message received: snapshotType={}, tableNames={}, structures={}, timestamp={}, destination={}, encryptionProviderName={}", new Object[]{message.snapshotType(), message.tableNames(), message.structureNames(), message.timestampLong(), message.destination(), message.encryptionProviderName()});
            HybridTimestamp now = this.context.clock().now();
            return ((SnapshotCoordinatorRole)this.snapshotCoordinatorRole.get()).startSnapshotCreation(term, message.snapshotType(), Instant.ofEpochMilli(now.getPhysical()), message.timestamp() == null ? now : message.timestamp(), message.tableNames(), message.structureNames() == null ? Set.of() : message.structureNames(), message.destination(), message.encryptionProviderName());
        });
    }

    private CompletableFuture<UUID> prepareSnapshotRestoration(long term, RestoreSnapshotMessage message) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            LOG.info("RESTORE SNAPSHOT message received: target snapshot ID={}, tableNames={}, source={}, encryptionProviderName={}", new Object[]{message.targetSnapshotId(), message.tableNames(), message.source(), message.encryptionProviderName()});
            return ((SnapshotCoordinatorRole)this.snapshotCoordinatorRole.get()).prepareSnapshotRestoration(term, message.targetSnapshotId(), message.tableNames(), message.source(), message.encryptionProviderName());
        });
    }

    private CompletableFuture<UUID> prepareSnapshotDeletion(long term, DeleteSnapshotMessage message) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            LOG.info("DELETE SNAPSHOT message received: target snapshot ID={}", new Object[]{message.targetSnapshotId()});
            return ((SnapshotCoordinatorRole)this.snapshotCoordinatorRole.get()).prepareSnapshotDeletion(term, message.targetSnapshotId());
        });
    }

    @TestOnly
    public SnapshotManagerContext context() {
        return this.context;
    }
}

