/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.AbstractGlobalStateWatch;
import org.gridgain.internal.snapshots.SnapshotCancelledException;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotReader;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

class RestoreSnapshotGlobalStateWatch
extends AbstractGlobalStateWatch {
    private static final IgniteLogger LOG = Loggers.forClass(RestoreSnapshotGlobalStateWatch.class);
    private final SnapshotReader snapshotReader;

    RestoreSnapshotGlobalStateWatch(SnapshotManagerContext context) {
        super(context);
        this.snapshotReader = new SnapshotReader(context);
    }

    @Override
    void processNewStateEntry(Entry entry) {
        RestoreSnapshotGlobalState globalState = RestoreSnapshotGlobalStateSerializer.deserialize(entry.value());
        switch (globalState.status()) {
            case PREPARED: 
            case COMPLETED: {
                break;
            }
            case STARTED: {
                if (!globalState.nodeNames().contains(this.context.nodeName())) {
                    LOG.info("Received a snapshot restoration request, but the node is not in the list of target nodes, skipping.", new Object[0]);
                    break;
                }
                this.context.threadPool().execute(() -> {
                    LOG.info("Starting local restoration of snapshot {}, operation ID = {}.", new Object[]{globalState.targetSnapshotId(), globalState.operationId()});
                    this.startSnapshotRestoration(globalState, entry.revision());
                });
                break;
            }
            case FAILED: {
                this.context.threadPool().execute(() -> {
                    LOG.info("Restoration of snapshot failed [target snapshot ID = {}, operation ID = {}, reason = {}]", new Object[]{globalState.targetSnapshotId(), globalState.operationId(), globalState.description()});
                    this.cancelSnapshotRestoration(globalState);
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected snapshot status: " + globalState.status()));
            }
        }
    }

    private void startSnapshotRestoration(RestoreSnapshotGlobalState globalState, long causalityToken) {
        SnapshotContext<RestoreSnapshotGlobalState> snapshotContext = new SnapshotContext<RestoreSnapshotGlobalState>(globalState, this.context.snapshotFileSystemManager().snapshotFileSystem(globalState.targetSnapshotId(), globalState.snapshotUri()), this.context.busyLock(), causalityToken);
        if (!this.context.ongoingSnapshots().registerSnapshotOperation(snapshotContext)) {
            LOG.info("Skipping snapshot restoration, because the node is stopping", new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.initializeLocalState(snapshotContext).thenComposeAsync(v -> this.snapshotReader.restoreSnapshot(snapshotContext), (Executor)this.context.threadPool())).handleAsync((rowsCount, e) -> this.finalizeLocalState(snapshotContext, (Long)rowsCount, (Throwable)e), (Executor)this.context.threadPool())).thenCompose(Function.identity())).whenComplete((v, e) -> snapshotContext.complete());
    }

    private CompletableFuture<Void> initializeLocalState(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext) {
        return snapshotContext.inBusyLockAsync(() -> {
            ByteArray localStateKey = MetaStorageKeys.restoreSnapshotLocalStateKey(snapshotContext.operationId(), this.context.nodeName());
            LocalSnapshotState localState = new LocalSnapshotState(SnapshotStatus.STARTED, 0L);
            return this.context.metaStorageManager().put(localStateKey, LocalSnapshotStateSerializer.serialize(localState)).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.error("Unable to initialize local snapshot state", e);
                }
            });
        });
    }

    private CompletableFuture<Boolean> finalizeLocalState(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, @Nullable Long rowsCount, @Nullable Throwable e) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            byte[] finalState;
            if (e == null) {
                assert (rowsCount != null);
                finalState = LocalSnapshotStateSerializer.serialize(new LocalSnapshotState(SnapshotStatus.COMPLETED, rowsCount));
            } else {
                Throwable unwrapped = ExceptionUtils.unwrapCause((Throwable)e);
                if (unwrapped instanceof SnapshotCancelledException) {
                    LOG.info("Snapshot {} restoration has been cancelled", new Object[]{((RestoreSnapshotGlobalState)snapshotContext.snapshotState()).targetSnapshotId()});
                } else {
                    LOG.error("Error when restoring Snapshot {}.", e, new Object[]{((RestoreSnapshotGlobalState)snapshotContext.snapshotState()).targetSnapshotId()});
                }
                if (snapshotContext.isCancelledByCoordinator()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                finalState = LocalSnapshotStateSerializer.serialize(new LocalSnapshotState(SnapshotStatus.FAILED, 0L, RestoreSnapshotGlobalStateWatch.formatErrorMessage(unwrapped)));
            }
            ByteArray localStateKey = MetaStorageKeys.restoreSnapshotLocalStateKey(snapshotContext.operationId(), this.context.nodeName());
            CompletableFuture invokeFuture = this.context.metaStorageManager().invoke((Condition)Conditions.exists((ByteArray)localStateKey), List.of(Operations.put((ByteArray)localStateKey, (byte[])finalState)), List.of());
            return invokeFuture.whenComplete((v, e2) -> {
                if (e2 != null) {
                    LOG.error("Unable to finalize local snapshot state", e2);
                }
            });
        });
    }

    private static String formatErrorMessage(Throwable e) {
        return String.format("%s: %s", e.getClass(), e.getMessage());
    }

    private void cancelSnapshotRestoration(RestoreSnapshotGlobalState globalState) {
        this.context.ongoingSnapshots().cancelSnapshotOperationDueToRemoteFailure(globalState.operationId()).whenComplete((v, e) -> {
            ByteArray localStateKey = MetaStorageKeys.restoreSnapshotLocalStateKey(globalState.operationId(), this.context.nodeName());
            this.context.metaStorageManager().remove(localStateKey);
        });
    }
}

