/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.catalog.CatalogToSchemaDescriptorConverter;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class TableColumnDescriptorView {
    private final String name;
    private final ColumnType type;
    private final boolean nullable;
    private final int length;
    private final int precision;
    private final int scale;
    @Nullable
    private final DefaultValueView defaultValue;

    @JsonCreator
    public TableColumnDescriptorView(@JsonProperty(value="name") String name, @JsonProperty(value="type") ColumnType type, @JsonProperty(value="nullable") boolean nullable, @JsonProperty(value="length") int length, @JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="defaultValue") @Nullable DefaultValueView defaultValue) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.defaultValue = defaultValue;
    }

    TableColumnDescriptorView(CatalogTableColumnDescriptor descriptor) {
        this(descriptor.name(), descriptor.type(), descriptor.nullable(), descriptor.length(), descriptor.precision(), descriptor.scale(), DefaultValueView.create(descriptor.defaultValue()));
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="type")
    public ColumnType type() {
        return this.type;
    }

    @JsonProperty(value="nullable")
    public boolean nullable() {
        return this.nullable;
    }

    @JsonProperty(value="length")
    public int length() {
        return this.length;
    }

    @JsonProperty(value="precision")
    public int precision() {
        return this.precision;
    }

    @JsonProperty(value="scale")
    public int scale() {
        return this.scale;
    }

    @JsonProperty(value="defaultValue")
    @Nullable
    public DefaultValueView defaultValue() {
        return this.defaultValue;
    }

    public ColumnParams toColumnParams() {
        ColumnParams.Builder builder = ColumnParams.builder().name(this.name).precision(this.type.precisionAllowed() ? Integer.valueOf(this.precision) : null).type(this.type).length(this.type.lengthAllowed() ? Integer.valueOf(this.length) : null).nullable(this.nullable).scale(this.type.scaleAllowed() ? Integer.valueOf(this.scale) : null);
        if (this.defaultValue != null) {
            builder.defaultValue(this.defaultValue.toDefaultValue());
        }
        return builder.build();
    }

    public Column toColumn() {
        return CatalogToSchemaDescriptorConverter.convert((CatalogTableColumnDescriptor)new CatalogTableColumnDescriptor(this.name(), this.type(), this.nullable(), this.precision(), this.scale(), this.length(), this.defaultValue() == null ? null : this.defaultValue().toDefaultValue()));
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=FunctionCallDefaultValueView.class, name="functionCall"), @JsonSubTypes.Type(value=ConstantDefaultValueView.class, name="constant")})
    public static abstract class DefaultValueView {
        @Nullable
        public static DefaultValueView create(@Nullable DefaultValue value) {
            if (value == null) {
                return null;
            }
            switch (value.type()) {
                case FUNCTION_CALL: {
                    return new FunctionCallDefaultValueView(((DefaultValue.FunctionCall)value).functionName());
                }
                case CONSTANT: {
                    return new ConstantDefaultValueView(((DefaultValue.ConstantValue)value).value());
                }
            }
            throw new IllegalArgumentException("Unknown DefaultValue type: " + value.type());
        }

        public abstract DefaultValue toDefaultValue();
    }

    public static class ConstantDefaultValueView
    extends DefaultValueView {
        @Nullable
        private final Object value;

        @JsonCreator
        public ConstantDefaultValueView(@JsonProperty(value="value") @Nullable Object value) {
            this.value = value;
        }

        @JsonProperty(value="value")
        @Nullable
        public Object value() {
            return this.value;
        }

        @Override
        public DefaultValue toDefaultValue() {
            return DefaultValue.constant((Object)this.value);
        }
    }

    public static class FunctionCallDefaultValueView
    extends DefaultValueView {
        private final String functionName;

        @JsonCreator
        public FunctionCallDefaultValueView(@JsonProperty(value="functionName") String functionName) {
            this.functionName = functionName;
        }

        @JsonProperty(value="functionName")
        public String functionName() {
            return this.functionName;
        }

        @Override
        public DefaultValue toDefaultValue() {
            return DefaultValue.functionCall((String)this.functionName);
        }
    }
}

