/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.DeleteSnapshotLocalStateWatch;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;
import org.gridgain.internal.snapshots.coordinator.SnapshotOperations;

class SnapshotDeletionProcess {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotDeletionProcess.class);
    private final SnapshotManagerContext context;
    private final SnapshotCoordinatorState snapshotCoordinatorState;
    private final SnapshotOperations snapshotOperations;

    SnapshotDeletionProcess(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState) {
        this.context = context;
        this.snapshotCoordinatorState = snapshotCoordinatorState;
        this.snapshotOperations = new SnapshotOperations(context);
    }

    CompletableFuture<DeleteSnapshotGlobalState> prepareSnapshotDeletion(CreateSnapshotGlobalState createGlobalState, Instant startTime) {
        if (!createGlobalState.dependentSnapshotIds().isEmpty()) {
            throw new SnapshotException(String.format("Unable to delete Snapshot %s. It has dependent Snapshots: %s", createGlobalState.snapshotId(), createGlobalState.dependentSnapshotIds()));
        }
        DeleteSnapshotGlobalState deleteGlobalState = new DeleteSnapshotGlobalState(UUID.randomUUID(), SnapshotStatus.STARTED, createGlobalState.nodeNames(), createGlobalState.snapshotId(), startTime, createGlobalState.description(), createGlobalState.parentSnapshotId(), createGlobalState.snapshotUri());
        return ((CompletableFuture)this.validateTopology(deleteGlobalState).thenComposeAsync(v -> this.prepareSnapshotDeletionAfterTopologyValidated(createGlobalState, deleteGlobalState), (Executor)this.context.threadPool())).thenApply(v -> deleteGlobalState);
    }

    private CompletableFuture<Void> prepareSnapshotDeletionAfterTopologyValidated(CreateSnapshotGlobalState createGlobalState, DeleteSnapshotGlobalState deleteGlobalState) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            UUID snapshotId = deleteGlobalState.targetSnapshotId();
            ByteArray createGlobalKey = MetaStorageKeys.createSnapshotGlobalStateKey(snapshotId);
            ByteArray deleteLockKey = MetaStorageKeys.deleteSnapshotLockKey(snapshotId);
            Condition condition = Conditions.exists((ByteArray)createGlobalKey).and((Condition)Conditions.value((ByteArray)MetaStorageKeys.restoreSnapshotLockKey()).ne(ByteUtils.uuidToBytes((UUID)snapshotId))).and((Condition)Conditions.notExists((ByteArray)deleteLockKey));
            List<Operation> operations = List.of(Operations.put((ByteArray)MetaStorageKeys.deleteSnapshotGlobalStateKey(deleteGlobalState.operationId()), (byte[])DeleteSnapshotGlobalStateSerializer.serialize(deleteGlobalState)), Operations.put((ByteArray)MetaStorageKeys.coordinatorTermKey(deleteGlobalState.operationId()), (byte[])ByteUtils.longToBytesKeepingOrder((long)this.snapshotCoordinatorState.term())), Operations.put((ByteArray)deleteLockKey, (byte[])ArrayUtils.BYTE_EMPTY_ARRAY), Operations.remove((ByteArray)createGlobalKey));
            DeleteSnapshotLocalStateWatch localStateWatch = new DeleteSnapshotLocalStateWatch(this.context, this.snapshotCoordinatorState, deleteGlobalState);
            this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.deleteSnapshotLocalStatePrefix(deleteGlobalState.operationId()), (WatchListener)localStateWatch);
            return ((CompletableFuture)((CompletableFuture)this.context.metaStorageManager().invoke(condition, operations, List.of()).handleAsync((success, e) -> {
                if (e != null) {
                    LOG.error("Unable to start snapshot deletion {}, operation ID {}: {}", e, new Object[]{deleteGlobalState.targetSnapshotId(), deleteGlobalState.operationId(), e.getMessage()});
                    localStateWatch.onSnapshotFailed(this.context.nodeName(), e.getMessage());
                    throw new SnapshotException("Unable to start snapshot deletion: " + e.getMessage(), (Throwable)e);
                }
                if (!success.booleanValue()) {
                    localStateWatch.onSnapshotFailed(this.context.nodeName(), "snapshot is locked");
                    throw new SnapshotException(String.format("Unable to start snapshot deletion %s, operation ID %s: this Snapshot is locked (removing or restoring by another operation).", deleteGlobalState.targetSnapshotId(), deleteGlobalState.operationId()));
                }
                return null;
            }, (Executor)this.context.threadPool())).thenCompose(v -> this.snapshotOperations.removeFromParentSnapshotDependencies(createGlobalState))).thenCompose(v -> this.revalidateTopologyAndRecover(deleteGlobalState, localStateWatch, createGlobalState));
        });
    }

    private CompletableFuture<Void> validateTopology(DeleteSnapshotGlobalState globalState) {
        return this.findMissingNodes(globalState).thenAccept(missingNodes -> {
            if (!missingNodes.isEmpty()) {
                throw new SnapshotException(String.format("Unable to delete Snapshot %s. Some nodes are missing from the topology: %s", globalState.targetSnapshotId(), missingNodes));
            }
        });
    }

    private CompletableFuture<Set<String>> findMissingNodes(DeleteSnapshotGlobalState globalState) {
        return this.context.logicalTopologyService().logicalTopologyOnLeader().thenApply(topology -> {
            Set topologyNodes = topology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            Set<String> snapshotNodes = globalState.nodeNames();
            return CollectionUtils.difference(snapshotNodes, topologyNodes);
        });
    }

    private CompletionStage<Void> revalidateTopologyAndRecover(DeleteSnapshotGlobalState globalState, DeleteSnapshotLocalStateWatch localStateWatch, CreateSnapshotGlobalState createSnapshotState) {
        return this.findMissingNodes(globalState).thenCompose(missingNodes -> {
            if (!missingNodes.isEmpty()) {
                return this.recover(globalState, localStateWatch, createSnapshotState, "topology has changed", "Some nodes are missing from the topology: " + missingNodes);
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private CompletionStage<Void> recover(DeleteSnapshotGlobalState globalState, DeleteSnapshotLocalStateWatch localStateWatch, CreateSnapshotGlobalState createState, String reason, String humanReadableReason) {
        return localStateWatch.onSnapshotFailed(this.context.nodeName(), reason).thenCompose(v -> {
            assert (createState.dependentSnapshotIds().isEmpty());
            CreateSnapshotGlobalState failedCreatedState = new CreateSnapshotGlobalState(createState.operationId(), SnapshotStatus.FAILED, createState.nodeNames(), createState.startTime(), createState.tableIds(), createState.tableNames(), createState.fromTimestamp(), createState.timestamp(), createState.description(), createState.parentSnapshotId(), createState.dependentSnapshotIds(), createState.snapshotUri(), createState.encryptionProviderName());
            return this.context.metaStorageManager().put(MetaStorageKeys.createSnapshotGlobalStateKey(failedCreatedState.snapshotId()), CreateSnapshotGlobalStateSerializer.serialize(failedCreatedState)).handle((success, e) -> {
                if (e != null) {
                    LOG.error("Unable to recover snapshot deletion {}, operation ID {}: {}", e, new Object[]{globalState.targetSnapshotId(), globalState.operationId(), e.getMessage()});
                    throw new SnapshotException(String.format("Snapshot %s deletion failed with reason: %s. Unable to recover: %s", globalState.targetSnapshotId(), humanReadableReason, e.getMessage()), (Throwable)e);
                }
                throw new SnapshotException(String.format("Snapshot %s deletion failed with reason: %s.", globalState.targetSnapshotId(), humanReadableReason));
            });
        });
    }
}

