/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.BulkUpdateProducer;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.UpdateProducer;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.HashIndexDescriptorView;
import org.gridgain.internal.snapshots.meta.IndexColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.IndexDescriptorView;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.SortedIndexDescriptorView;
import org.gridgain.internal.snapshots.meta.StorageProfileDescriptorView;
import org.gridgain.internal.snapshots.meta.TableColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;
import org.gridgain.internal.snapshots.meta.ZoneDescriptorView;

public class CreateTemporaryTablesCommand
implements CatalogCommand {
    private final String tmpTableNamePrefix;
    private final SnapshotMeta snapshotMeta;

    public CreateTemporaryTablesCommand(String tmpTableNamePrefix, SnapshotMeta snapshotMeta) {
        this.tmpTableNamePrefix = tmpTableNamePrefix;
        this.snapshotMeta = snapshotMeta;
    }

    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        this.createZones(commandState);
        this.createTablesAndIndices(commandState);
        return commandState.updateEntries();
    }

    private void createZones(CommandState commandState) {
        for (ZoneDescriptorView zoneView : this.snapshotMeta.zoneDescriptors()) {
            if (commandState.catalog().zone(zoneView.name()) != null) continue;
            commandState.applyCommand((UpdateProducer)CreateTemporaryTablesCommand.createZoneCommand(zoneView));
        }
    }

    private void createTablesAndIndices(CommandState commandState) {
        ArrayList<CatalogCommand> commands = new ArrayList<CatalogCommand>();
        for (TableSnapshotMeta tableSnapshotMeta : this.snapshotMeta.tableSnapshotMetas()) {
            TableDescriptorView tableView = tableSnapshotMeta.schema().tableDescriptor();
            TmpTableName tmpTableName = new TmpTableName(tableView.schemaName(), this.tmpTableNamePrefix + tableView.name());
            IndexDescriptorView pkIndexView = tableSnapshotMeta.schema().pkIndexDescriptor();
            commands.add(CreateTemporaryTablesCommand.createTableCommand(tableView, tmpTableName, CreateTemporaryTablesCommand.primaryKey(pkIndexView)));
            for (IndexDescriptorView indexView : tableSnapshotMeta.schema().secondaryIndexDescriptors()) {
                CatalogCommand indexCreateCommand = CreateTemporaryTablesCommand.createIndexCommand(indexView, tmpTableName, this.tmpTableNamePrefix + indexView.name());
                commands.add(indexCreateCommand);
            }
        }
        commandState.applyCommand((UpdateProducer)new BulkUpdateProducer(commands));
    }

    private static CatalogCommand createZoneCommand(ZoneDescriptorView zoneView) {
        return ((CreateZoneCommandBuilder)CreateZoneCommand.builder((f, sp, r) -> zoneView.partitions()).zoneName(zoneView.name())).partitions(Integer.valueOf(zoneView.partitions())).replicas(Integer.valueOf(zoneView.replicas())).dataNodesAutoAdjustScaleDown(zoneView.dataNodesAutoAdjustScaleDown() == Integer.MAX_VALUE ? null : Integer.valueOf(zoneView.dataNodesAutoAdjustScaleDown())).dataNodesAutoAdjustScaleUp(zoneView.dataNodesAutoAdjustScaleUp() == 0 ? null : Integer.valueOf(zoneView.dataNodesAutoAdjustScaleUp())).filter(zoneView.filter()).storageProfilesParams(zoneView.storageProfiles().storageProfiles().stream().map(StorageProfileDescriptorView::toStorageProfileParams).collect(Collectors.toList())).build();
    }

    private static CatalogCommand createTableCommand(TableDescriptorView tableView, TmpTableName tableName, TablePrimaryKey primaryKey) {
        return ((CreateTableCommandBuilder)((CreateTableCommandBuilder)CreateTableCommand.builder().tableName(tableName.tableName)).schemaName(tableName.schemaName)).zone(tableView.zoneName()).secondaryZone(tableView.secondaryZoneName()).columns(tableView.columns().stream().map(TableColumnDescriptorView::toColumnParams).collect(Collectors.toList())).primaryKey(primaryKey).colocationColumns(tableView.colocationColumns()).storageProfile(tableView.storageProfile()).secondaryStorageProfile(tableView.secondaryStorageProfile()).expireColumn(tableView.expireColumn()).archiveColumn(tableView.archiveColumn()).build();
    }

    private static TablePrimaryKey primaryKey(IndexDescriptorView pkIndexView) {
        if (pkIndexView instanceof HashIndexDescriptorView) {
            return TableHashPrimaryKey.builder().columns(((HashIndexDescriptorView)pkIndexView).columns()).build();
        }
        List<IndexColumnDescriptorView> columnViews = ((SortedIndexDescriptorView)pkIndexView).columns();
        ArrayList<String> columnNames = new ArrayList<String>(columnViews.size());
        ArrayList<CatalogColumnCollation> collations = new ArrayList<CatalogColumnCollation>(columnViews.size());
        for (IndexColumnDescriptorView columnView : columnViews) {
            columnNames.add(columnView.name());
            collations.add(columnView.collation());
        }
        return TableSortedPrimaryKey.builder().columns(columnNames).collations(collations).build();
    }

    private static CatalogCommand createIndexCommand(IndexDescriptorView indexView, TmpTableName tableName, String indexName) {
        if (indexView instanceof HashIndexDescriptorView) {
            return CreateTemporaryTablesCommand.createHashIndexCommand((HashIndexDescriptorView)indexView, tableName, indexName);
        }
        if (indexView instanceof SortedIndexDescriptorView) {
            return CreateTemporaryTablesCommand.createSortedIndexCommand((SortedIndexDescriptorView)indexView, tableName, indexName);
        }
        throw new IllegalArgumentException("Unknown index descriptor type: " + indexView.getClass());
    }

    private static CatalogCommand createHashIndexCommand(HashIndexDescriptorView indexView, TmpTableName tableName, String indexName) {
        return ((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)CreateHashIndexCommand.builder().indexName(indexName)).tableName(tableName.tableName)).schemaName(tableName.schemaName)).unique(indexView.unique())).columns(indexView.columns())).build();
    }

    private static CatalogCommand createSortedIndexCommand(SortedIndexDescriptorView indexView, TmpTableName tableName, String indexName) {
        List<IndexColumnDescriptorView> columnViews = indexView.columns();
        ArrayList<String> columnNames = new ArrayList<String>(columnViews.size());
        ArrayList<CatalogColumnCollation> collations = new ArrayList<CatalogColumnCollation>(columnViews.size());
        for (IndexColumnDescriptorView columnView : columnViews) {
            columnNames.add(columnView.name());
            collations.add(columnView.collation());
        }
        return ((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)CreateSortedIndexCommand.builder().indexName(indexName)).tableName(tableName.tableName)).schemaName(tableName.schemaName)).unique(indexView.unique())).columns(columnNames)).collations(collations).build();
    }

    private static class TmpTableName {
        final String schemaName;
        final String tableName;

        TmpTableName(String schemaName, String tableName) {
            this.schemaName = schemaName;
            this.tableName = tableName;
        }
    }
}

