/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.AbstractGlobalStateWatch;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.gridgain.internal.snapshots.SnapshotDeleter;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

class DeleteSnapshotGlobalStateWatch
extends AbstractGlobalStateWatch {
    private static final IgniteLogger LOG = Loggers.forClass(DeleteSnapshotGlobalStateWatch.class);
    private final SnapshotDeleter snapshotDeleter;

    DeleteSnapshotGlobalStateWatch(SnapshotManagerContext context) {
        super(context);
        this.snapshotDeleter = new SnapshotDeleter(context);
    }

    @Override
    void processNewStateEntry(Entry entry) {
        DeleteSnapshotGlobalState globalState = DeleteSnapshotGlobalStateSerializer.deserialize(entry.value());
        switch (globalState.status()) {
            case PREPARED: 
            case COMPLETED: {
                break;
            }
            case STARTED: {
                if (!globalState.nodeNames().contains(this.context.nodeName())) {
                    LOG.info("Received a snapshot deletion request, but the node is not in the list of target nodes, skipping.", new Object[0]);
                    break;
                }
                this.context.threadPool().execute(() -> {
                    LOG.info("Starting deletion of snapshot {}, operation ID = {}.", new Object[]{globalState.targetSnapshotId(), globalState.operationId()});
                    this.startSnapshotDeletion(globalState, entry.revision());
                });
                break;
            }
            case FAILED: {
                this.context.threadPool().execute(() -> {
                    LOG.info("Deletion of snapshot failed [target snapshot ID = {}, operation ID = {}, reason = {}]", new Object[]{globalState.targetSnapshotId(), globalState.operationId(), globalState.description()});
                    this.cancelSnapshotDeletion(globalState);
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected snapshot status: " + globalState.status()));
            }
        }
    }

    private void startSnapshotDeletion(DeleteSnapshotGlobalState globalState, long causalityToken) {
        SnapshotContext<DeleteSnapshotGlobalState> snapshotContext = new SnapshotContext<DeleteSnapshotGlobalState>(globalState, this.context.snapshotFileSystemManager().snapshotFileSystem(globalState.targetSnapshotId(), globalState.snapshotUri()), this.context.busyLock(), causalityToken);
        if (!this.context.ongoingSnapshots().registerSnapshotOperation(snapshotContext)) {
            LOG.info("Skipping snapshot deletion, because the node is stopping", new Object[0]);
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.initializeLocalState(snapshotContext).thenComposeAsync(v -> this.snapshotDeleter.deleteSnapshot(snapshotContext), (Executor)this.context.threadPool())).handleAsync((v, e) -> this.finalizeLocalState(snapshotContext, (Throwable)e), (Executor)this.context.threadPool())).thenCompose(Function.identity())).whenComplete((v, e) -> snapshotContext.complete());
    }

    private CompletableFuture<Void> initializeLocalState(SnapshotContext<DeleteSnapshotGlobalState> snapshotContext) {
        return snapshotContext.inBusyLockAsync(() -> {
            ByteArray localStateKey = MetaStorageKeys.deleteSnapshotLocalStateKey(snapshotContext.operationId(), this.context.nodeName());
            LocalSnapshotState localState = new LocalSnapshotState(SnapshotStatus.STARTED, 0L);
            return this.context.metaStorageManager().put(localStateKey, LocalSnapshotStateSerializer.serialize(localState)).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.error("Unable to initialize local snapshot state", e);
                }
            });
        });
    }

    private CompletableFuture<Boolean> finalizeLocalState(SnapshotContext<DeleteSnapshotGlobalState> snapshotContext, @Nullable Throwable e) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.context.busyLock(), () -> {
            byte[] finalState;
            if (e == null) {
                LOG.info("Data for Snapshot {} has been successfully deleted.", new Object[]{((DeleteSnapshotGlobalState)snapshotContext.snapshotState()).targetSnapshotId()});
                finalState = LocalSnapshotStateSerializer.serialize(new LocalSnapshotState(SnapshotStatus.COMPLETED, 0L));
            } else {
                LOG.error("Error when deleting Snapshot {}.", e, new Object[]{snapshotContext.operationId()});
                finalState = LocalSnapshotStateSerializer.serialize(new LocalSnapshotState(SnapshotStatus.FAILED, 0L, DeleteSnapshotGlobalStateWatch.formatErrorMessage(ExceptionUtils.unwrapCause((Throwable)e))));
            }
            ByteArray localStateKey = MetaStorageKeys.deleteSnapshotLocalStateKey(snapshotContext.operationId(), this.context.nodeName());
            CompletableFuture invokeFuture = this.context.metaStorageManager().invoke((Condition)Conditions.exists((ByteArray)localStateKey), List.of(Operations.put((ByteArray)localStateKey, (byte[])finalState)), List.of());
            return invokeFuture.whenComplete((v, e2) -> {
                if (e2 != null) {
                    LOG.error("Unable to finalize local snapshot state", e2);
                }
            });
        });
    }

    private static String formatErrorMessage(Throwable e) {
        return String.format("%s: %s", e.getClass(), e.getMessage());
    }

    private void cancelSnapshotDeletion(DeleteSnapshotGlobalState globalState) {
        this.context.ongoingSnapshots().cancelSnapshotOperationDueToRemoteFailure(globalState.operationId()).whenComplete((v, e) -> {
            ByteArray localStateKey = MetaStorageKeys.deleteSnapshotLocalStateKey(globalState.operationId(), this.context.nodeName());
            this.context.metaStorageManager().remove(localStateKey);
        });
    }
}

