/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.apache.ignite.internal.util.Lazy;
import org.gridgain.internal.snapshots.buffer.ByteBufferPool;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.EncryptionByteBufferPool;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;
import org.gridgain.internal.snapshots.configuration.NodeSnapshotConfiguration;

public class SnapshotBufferManager
implements ByteBufferPoolProvider {
    private final Map<Integer, EncryptionByteBufferPool> encryptionBufferPools = new ConcurrentHashMap<Integer, EncryptionByteBufferPool>();
    private final Lazy<ByteBufferPool> diskBufferPool = new Lazy(this::diskBufferPool);
    private final NodeSnapshotConfiguration nodeSnapshotConfiguration;

    public SnapshotBufferManager(NodeSnapshotConfiguration nodeSnapshotConfiguration) {
        this.nodeSnapshotConfiguration = nodeSnapshotConfiguration;
    }

    @Override
    public EncryptionByteBufferPool encryptionPool(Cipher cipher) {
        return this.encryptionBufferPools.computeIfAbsent(cipher.getBlockSize(), blockSize -> {
            int poolCapacity = (Integer)this.nodeSnapshotConfiguration.encryptionBuffersCapacityBytes().value();
            int chunkSize = (Integer)this.nodeSnapshotConfiguration.snapshotChunkSizeBytes().value();
            int encryptedChunkSize = SnapshotEncryptor.computeTargetEncryptedBufferSize(blockSize, chunkSize);
            final ByteBufferPool srcBufferPool = new ByteBufferPool(poolCapacity, chunkSize);
            final ByteBufferPool dstBufferPool = new ByteBufferPool(poolCapacity + poolCapacity % chunkSize * (encryptedChunkSize - chunkSize), encryptedChunkSize);
            return new EncryptionByteBufferPool(){

                @Override
                public ByteBufferPool encryptedBlocksPool() {
                    return srcBufferPool;
                }

                @Override
                public ByteBufferPool dataPool() {
                    return dstBufferPool;
                }
            };
        });
    }

    @Override
    public ByteBufferPool flushToDiskPool() {
        return (ByteBufferPool)this.diskBufferPool.get();
    }

    private ByteBufferPool diskBufferPool() {
        return new ByteBufferPool((Integer)this.nodeSnapshotConfiguration.diskBuffersCapacityBytes().value(), (Integer)this.nodeSnapshotConfiguration.snapshotDiskBufferSizeBytes().value());
    }
}

