/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.security.GeneralSecurityException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.lang.ErrorGroups;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;

public class DataKeyGenerator {
    private static final String DEFAULT_DATA_ENCRYPTION_CIPHER = "AES/CBC/NoPadding";
    private static final String ALGORITHM = "AES";
    private static final int DEFAULT_DATA_KEY_SIZE = 256;

    public static DataEncryptionKey create(int id) {
        try {
            KeyGenerator gen = KeyGenerator.getInstance(ALGORITHM);
            gen.init(256);
            SecretKey key = gen.generateKey();
            return new DataEncryptionKey(id, key);
        }
        catch (GeneralSecurityException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    public static String defaultCipherAlgorithm() {
        return DEFAULT_DATA_ENCRYPTION_CIPHER;
    }
}

