/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context.message;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.security.context.message.UserContext;
import org.gridgain.internal.security.context.message.UserContextBuilder;
import org.gridgain.internal.security.context.message.UserContextSerializer;

public class UserContextImpl
implements UserContext,
Cloneable {
    public static final short GROUP_TYPE = 1100;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final Set<String> roles;
    @IgniteToStringInclude
    private final String username;

    private UserContextImpl(Set<String> roles, String username) {
        this.roles = roles;
        this.username = username;
    }

    @Override
    public Set<String> roles() {
        return this.roles;
    }

    @Override
    public String username() {
        return this.username;
    }

    public MessageSerializer serializer() {
        return UserContextSerializer.INSTANCE;
    }

    public short groupType() {
        return 1100;
    }

    public String toString() {
        return S.toString(UserContextImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UserContextImpl otherMessage = (UserContextImpl)other;
        return Objects.equals(this.roles, otherMessage.roles) && Objects.equals(this.username, otherMessage.username);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.roles, this.username);
        return result;
    }

    public UserContextImpl clone() {
        try {
            return (UserContextImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UserContextBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements UserContextBuilder {
        private Set<String> roles;
        private String username;

        private Builder() {
        }

        @Override
        public UserContextBuilder roles(Set<String> roles) {
            Objects.requireNonNull(roles, "roles is not marked @Nullable");
            this.roles = roles;
            return this;
        }

        @Override
        public UserContextBuilder username(String username) {
            Objects.requireNonNull(username, "username is not marked @Nullable");
            this.username = username;
            return this;
        }

        @Override
        public Set<String> roles() {
            return this.roles;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public UserContext build() {
            return new UserContextImpl(Objects.requireNonNull(this.roles, "roles is not marked @Nullable"), Objects.requireNonNull(this.username, "username is not marked @Nullable"));
        }

        @Override
        public UserContext buildDeserialized() {
            return new UserContextImpl(this.roles, this.username);
        }
    }
}

