/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import java.util.function.Supplier;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class SecuredSupplier<T>
implements Supplier<T> {
    private final Supplier<T> original;
    private final SecurityContext capturedContext;

    SecuredSupplier(Supplier<T> original, @Nullable SecurityContext capturedContext) {
        this.original = original;
        this.capturedContext = capturedContext;
    }

    @Override
    public T get() {
        SecurityContext currentContext = SecurityContextHolder.getOrNull();
        try {
            SecurityContextHolder.set(this.capturedContext);
            T t = this.original.get();
            return t;
        }
        finally {
            SecurityContextHolder.set(currentContext);
        }
    }
}

