/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class SecuredRunnable
implements Runnable {
    private final Runnable original;
    private final SecurityContext capturedContext;

    SecuredRunnable(Runnable original, @Nullable SecurityContext capturedContext) {
        this.original = original;
        this.capturedContext = capturedContext;
    }

    @Override
    public void run() {
        SecurityContext currentContext = SecurityContextHolder.getOrNull();
        try {
            SecurityContextHolder.set(this.capturedContext);
            this.original.run();
        }
        finally {
            SecurityContextHolder.set(currentContext);
        }
    }
}

