/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import java.util.function.Function;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class SecuredFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> original;
    private final SecurityContext capturedContext;

    SecuredFunction(Function<T, R> original, @Nullable SecurityContext capturedContext) {
        this.original = original;
        this.capturedContext = capturedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T t) {
        SecurityContext currentContext = SecurityContextHolder.getOrNull();
        try {
            SecurityContextHolder.set(this.capturedContext);
            R r = this.original.apply(t);
            return r;
        }
        finally {
            SecurityContextHolder.set(currentContext);
        }
    }
}

