/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import java.util.function.Consumer;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class SecuredConsumer<T>
implements Consumer<T> {
    private final Consumer<T> original;
    private final SecurityContext capturedContext;

    SecuredConsumer(Consumer<T> original, @Nullable SecurityContext capturedContext) {
        this.original = original;
        this.capturedContext = capturedContext;
    }

    @Override
    public void accept(T t) {
        SecurityContext currentContext = SecurityContextHolder.getOrNull();
        try {
            SecurityContextHolder.set(this.capturedContext);
            this.original.accept(t);
        }
        finally {
            SecurityContextHolder.set(currentContext);
        }
    }
}

