/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.context;

import java.util.concurrent.Callable;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class SecuredCallable<T>
implements Callable<T> {
    private final Callable<T> original;
    private final SecurityContext capturedContext;

    SecuredCallable(Callable<T> original, @Nullable SecurityContext capturedContext) {
        this.original = original;
        this.capturedContext = capturedContext;
    }

    @Override
    public T call() throws Exception {
        SecurityContext currentContext = SecurityContextHolder.getOrNull();
        try {
            SecurityContextHolder.set(this.capturedContext);
            T t = this.original.call();
            return t;
        }
        finally {
            SecurityContextHolder.set(currentContext);
        }
    }
}

