/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.secondarystoragebridge.rocksdb;

import java.nio.charset.StandardCharsets;
import org.rocksdb.RocksDB;

public class UpdatesStorageColumnFamily {
    public static final String META_CF_NAME = new String(RocksDB.DEFAULT_COLUMN_FAMILY, StandardCharsets.UTF_8);
    public static final String DATA_CF_NAME = "cf-data";
    public static final String COMMITTED_TX_NAME = "cf-committed";
    public static final String ONGOING_TX_NAME = "cf-ongoing";

    public static enum ColumnFamilyType {
        META,
        DATA,
        COMMITTED,
        ONGOING;


        public static ColumnFamilyType fromCfName(String cfName) {
            if (META_CF_NAME.equals(cfName)) {
                return META;
            }
            if (UpdatesStorageColumnFamily.DATA_CF_NAME.equals(cfName)) {
                return DATA;
            }
            if (UpdatesStorageColumnFamily.COMMITTED_TX_NAME.equals(cfName)) {
                return COMMITTED;
            }
            if (UpdatesStorageColumnFamily.ONGOING_TX_NAME.equals(cfName)) {
                return ONGOING;
            }
            throw new IllegalArgumentException("Unexpected column family: " + cfName);
        }
    }
}

