/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.secondarystoragebridge.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowImpl;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.secondarystoragebridge.SecondaryStorageBridgeException;
import org.apache.ignite.internal.secondarystoragebridge.TransactionInfo;
import org.apache.ignite.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite.internal.secondarystoragebridge.rocksdb.RocksDbSecondaryStorageBridge;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.lease.LeaseInfoSerializer;
import org.apache.ignite.internal.storage.secondary.BinaryRowAndRowId;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.ReadTier;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbUpdatesStorage
implements UpdatesStorage,
AutoCloseable {
    public static final int TX_COUNT_THRESHOLD = 10;
    private static final ByteOrder ORDER;
    private static final int TABLE_PARTITION_ID_PREFIX_SIZE = 6;
    private static final int DATA_KEY_SIZE = 38;
    static final int DATA_KEY_PREFIX_SIZE = 22;
    private static final int COMMITTED_TRANSACTIONS_KEY_SIZE = 14;
    static final int COMMITTED_TRANSACTIONS_KEY_PREFIX_SIZE = 6;
    private static final int ONGOING_TRANSACTIONS_KEY_SIZE = 22;
    static final int ONGOING_TRANSACTIONS_KEY_PREFIX_SIZE = 6;
    static final int META_KEY_PREFIX_SIZE = 6;
    private static final int META_KEY_SIZE = 6;
    private static final byte CONFIGURATION_KEY_SUFFIX = 1;
    private static final byte LEASE_KEY_SUFFIX = 3;
    private static final ThreadLocal<ByteBuffer> TX_DATA_KEY_BUFFER;
    private static final ThreadLocal<ByteBuffer> TX_DATA_PREFIX_BUFFER;
    private static final ThreadLocal<ByteBuffer> ONGOING_TX_KEY_BUFFER;
    private static final ThreadLocal<ByteBuffer> COMMITED_TX_KEY_BUFFER;
    private final ColumnFamily metaCf;
    private final ColumnFamily dataCf;
    private final ColumnFamily committedTransactionsCf;
    private final ColumnFamily ongoingTransactionsCf;
    private final RocksDbSecondaryStorageBridge storageBridge;
    private final WriteOptions writeOpts = new WriteOptions().setDisableWAL(true);
    private final int tableId;
    private final short partitionId;
    private final byte[] appliedIndexTermKey;
    private final byte[] configurationKey;
    private final byte[] leaseKey;
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private volatile long leaseStartTime;
    @Nullable
    private volatile UUID primaryReplicaNodeId;
    @Nullable
    private volatile String primaryReplicaNodeName;
    private volatile long persistedIndex;
    private final Object mux = new Object();
    private final NavigableSet<HybridTimestamp> ongoingTransactions = new TreeSet<HybridTimestamp>();
    private final NavigableSet<HybridTimestamp> commitedTransactions = new TreeSet<HybridTimestamp>();

    public RocksDbUpdatesStorage(RocksDbSecondaryStorageBridge storageBridge, int tableId, int partitionId) {
        this.storageBridge = storageBridge;
        this.metaCf = storageBridge.metaColumnFamily();
        this.dataCf = storageBridge.dataColumnFamily();
        this.committedTransactionsCf = storageBridge.committedTransactionsColumnFamily();
        this.ongoingTransactionsCf = storageBridge.ongoingTransactionsColumnFamily();
        this.tableId = tableId;
        this.partitionId = (short)partitionId;
        this.appliedIndexTermKey = RocksDbUpdatesStorage.compositeKeyToBytes(tableId, (short)partitionId);
        this.configurationKey = Arrays.copyOf(this.appliedIndexTermKey, this.appliedIndexTermKey.length + 1);
        this.configurationKey[this.appliedIndexTermKey.length] = 1;
        this.leaseKey = Arrays.copyOf(this.appliedIndexTermKey, this.appliedIndexTermKey.length + 1);
        this.leaseKey[this.appliedIndexTermKey.length] = 3;
        this.initLastApplied();
        this.initLeaseStartTime();
        this.initOngoingTransactions();
        this.initCommitedTransactions();
    }

    private void initLastApplied() {
        byte[] indexAndTerm = this.readLastApplied();
        if (indexAndTerm == null) {
            return;
        }
        this.lastAppliedIndex = ByteUtils.bytesToLong((byte[])indexAndTerm, (int)0);
        this.lastAppliedTerm = ByteUtils.bytesToLong((byte[])indexAndTerm, (int)8);
        this.persistedIndex = this.lastAppliedIndex;
    }

    private void initLeaseStartTime() {
        byte[] leaseBytes = this.readLease();
        if (leaseBytes == null) {
            this.leaseStartTime = HybridTimestamp.MIN_VALUE.longValue();
        } else {
            LeaseInfo leaseInfo = (LeaseInfo)VersionedSerialization.fromBytes((byte[])leaseBytes, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
            this.leaseStartTime = leaseInfo.leaseStartTime();
            this.primaryReplicaNodeId = leaseInfo.primaryReplicaNodeId();
            this.primaryReplicaNodeName = leaseInfo.primaryReplicaNodeName();
        }
    }

    private void initOngoingTransactions() {
        try (OngoingTransactionCursor cursor = this.createOngoingTransactionCursor();){
            cursor.forEach(this.ongoingTransactions::add);
        }
    }

    private void initCommitedTransactions() {
        try (Cursor<TransactionInfo> cursor = this.getCommittedTransactionIds(HybridTimestamp.MAX_VALUE);){
            cursor.forEach(item -> this.commitedTransactions.add(item.commitTimestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewWrite(UUID txId, RowId rowId, BinaryRow row) {
        assert (row != null) : "Binary row must contain primary key columns for a key removal or columns values which must be applied to the row.";
        byte[] txDataKey = this.txDataKey(txId, rowId);
        byte[] value = RocksDbUpdatesStorage.serializeRow(row).array();
        HybridTimestamp beginTimestamp = TransactionIds.beginTimestamp((UUID)txId);
        byte[] txKey = this.ongoingTxKey(beginTimestamp);
        try {
            this.dataCf.put(this.writeOpts, txDataKey, value);
            this.ongoingTransactionsCf.put(this.writeOpts, txKey, ArrayUtils.BYTE_EMPTY_ARRAY);
            Object object = this.mux;
            synchronized (object) {
                this.ongoingTransactions.add(beginTimestamp);
            }
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to add new write: tableId=%d, partId=%d, txId=%s, rowId=%s", this.tableId, this.partitionId, txId, rowId);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    private static ByteBuffer serializeRow(BinaryRow row) {
        return ByteBuffer.allocate(row.tupleSliceLength() + 2).order(ORDER).putShort((short)row.schemaVersion()).put(row.tupleSlice());
    }

    private static BinaryRow deserializeRow(ByteBuffer buffer) {
        assert (buffer.order() == ORDER);
        return new BinaryRowImpl((int)buffer.getShort(), buffer.slice().order(BinaryTuple.ORDER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransactionAborted(UUID txId) {
        try {
            byte[] txDataRangeStartKey = this.txDataRangeStartKey(txId);
            byte[] txDataRangeEndKey = RocksUtils.incrementPrefix((byte[])txDataRangeStartKey);
            HybridTimestamp beginTimestamp = TransactionIds.beginTimestamp((UUID)txId);
            byte[] ongoingTxKey = this.ongoingTxKey(beginTimestamp);
            this.dataCf.db().deleteRange(this.dataCf.handle(), this.writeOpts, txDataRangeStartKey, txDataRangeEndKey);
            Object object = this.mux;
            synchronized (object) {
                this.ongoingTransactions.remove(beginTimestamp);
            }
            this.ongoingTransactionsCf.db().delete(this.ongoingTransactionsCf.handle(), this.writeOpts, ongoingTxKey);
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to handle transaction abortion: tableId=%d, partId=%d, txId=%s", this.tableId, this.partitionId, txId);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    private void deleteTransactionData(WriteBatch writeBatch, UUID txId) throws RocksDBException {
        byte[] txDataRangeStartKey = this.txDataRangeStartKey(txId);
        byte[] txDataRangeEndKey = RocksUtils.incrementPrefix((byte[])txDataRangeStartKey);
        this.dataCf.deleteRange(writeBatch, txDataRangeStartKey, txDataRangeEndKey);
    }

    private boolean deleteTransactionData(WriteBatch writeBatch, UUID txId, RowId rowId) throws RocksDBException {
        boolean completeTransactionPurge;
        byte[] txDataRangeStartKey = this.txDataRangeStartKey(txId);
        byte[] txDataRangeEndKey = RocksUtils.incrementPrefix((byte[])txDataRangeStartKey);
        byte[] txDataRangeEndKeyForRowId = RocksUtils.incrementPrefix((byte[])this.txDataKey(txId, rowId));
        try (TransactionDataCursor cursor = this.createTransactionDataCursor(txDataRangeEndKeyForRowId, txDataRangeEndKey);){
            completeTransactionPurge = !cursor.hasNext();
        }
        this.dataCf.deleteRange(writeBatch, txDataRangeStartKey, txDataRangeEndKeyForRowId);
        return completeTransactionPurge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransactionCommitted(UUID txId, HybridTimestamp commitTimestamp) {
        byte[] key = this.committedTxKey(commitTimestamp);
        byte[] value = ByteUtils.uuidToBytes((UUID)txId);
        try {
            this.committedTransactionsCf.put(this.writeOpts, key, value);
            Object object = this.mux;
            synchronized (object) {
                this.ongoingTransactions.remove(TransactionIds.beginTimestamp((UUID)txId));
                this.commitedTransactions.add(commitTimestamp);
            }
            HybridTimestamp hybridTimestamp = TransactionIds.beginTimestamp((UUID)txId);
            byte[] ongoingTxKey = this.ongoingTxKey(hybridTimestamp);
            this.ongoingTransactionsCf.db().delete(this.ongoingTransactionsCf.handle(), this.writeOpts, ongoingTxKey);
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to handle transaction commit: tableId=%d, partId=%d, txId=%s, commitTs=%s", this.tableId, this.partitionId, txId, commitTimestamp);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTransactionData(HybridTimestamp upperBoundTimestamp, RowId upperBoundRowId) {
        try (WriteBatch batch = new WriteBatch();){
            boolean completeTransactionPurge = false;
            HashSet<HybridTimestamp> deletedTransactions = new HashSet<HybridTimestamp>();
            try (Cursor<TransactionInfo> txIds = this.getCommittedTransactionIds(upperBoundTimestamp);){
                while (txIds.hasNext()) {
                    TransactionInfo txInfo = (TransactionInfo)txIds.next();
                    UUID txId = txInfo.txId;
                    HybridTimestamp timestamp = txInfo.commitTimestamp;
                    if (timestamp.equals((Object)upperBoundTimestamp)) {
                        completeTransactionPurge = this.deleteTransactionData(batch, txId, upperBoundRowId);
                        if (!completeTransactionPurge) continue;
                        deletedTransactions.add(timestamp);
                        continue;
                    }
                    this.deleteTransactionData(batch, txId);
                    deletedTransactions.add(timestamp);
                }
            }
            byte[] startKey = this.committedTxStartKey();
            byte[] endKey = completeTransactionPurge ? RocksUtils.incrementPrefix((byte[])this.committedTxKey(upperBoundTimestamp)) : this.committedTxKey(upperBoundTimestamp);
            this.committedTransactionsCf.deleteRange(batch, startKey, endKey);
            this.dataCf.db().write(this.writeOpts, batch);
            Object object = this.mux;
            synchronized (object) {
                this.commitedTransactions.removeAll(deletedTransactions);
            }
        }
        catch (Exception e) {
            String msg = String.format("Failed to drop transaction data: tableId=%d, partId=%d, ts=%s", this.tableId, this.partitionId, this.committedTransactionsCf);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    @Override
    public void dropTransactionData(Collection<TransactionInfo> ids) {
        try (WriteBatch batch = new WriteBatch();){
            for (TransactionInfo txInfo : ids) {
                UUID txId = txInfo.txId;
                this.deleteTransactionData(batch, txId);
                this.committedTransactionsCf.delete(batch, this.committedTxKey(txInfo.commitTimestamp));
            }
            this.dataCf.db().write(this.writeOpts, batch);
        }
        catch (Exception e) {
            String msg = String.format("Failed to drop transaction data: tableId=%d, partId=%d, ts=%s", this.tableId, this.partitionId, this.committedTransactionsCf);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    @Override
    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    @Override
    public long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        try {
            byte[] indexAndTerm = new byte[16];
            ByteUtils.putLongToBytes((long)lastAppliedIndex, (byte[])indexAndTerm, (int)0);
            ByteUtils.putLongToBytes((long)lastAppliedTerm, (byte[])indexAndTerm, (int)8);
            this.metaCf.put(this.writeOpts, this.appliedIndexTermKey, indexAndTerm);
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to set last applied index: tableId=%d, partId=%d, idx=%d", this.tableId, this.partitionId, lastAppliedIndex);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    @Override
    public void updateConfiguration(long lastAppliedIndex, long lastAppliedTerm, byte[] configuration) {
        Objects.requireNonNull(configuration, "configuration");
        try (WriteBatch writeBatch = new WriteBatch();){
            byte[] indexAndTerm = new byte[16];
            ByteUtils.putLongToBytes((long)lastAppliedIndex, (byte[])indexAndTerm, (int)0);
            ByteUtils.putLongToBytes((long)lastAppliedTerm, (byte[])indexAndTerm, (int)8);
            this.metaCf.put(writeBatch, this.appliedIndexTermKey, indexAndTerm);
            this.metaCf.put(writeBatch, this.configurationKey, configuration);
            this.metaCf.db().write(this.writeOpts, writeBatch);
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to set last applied index: tableId=%d, partId=%d, idx=%d", this.tableId, this.partitionId, lastAppliedIndex);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_WRITE_ERR, msg, e);
        }
    }

    void refreshPersistedIndex() throws SecondaryStorageBridgeException {
        this.persistedIndex = this.readLastAppliedIndex();
    }

    private long readLastAppliedIndex() {
        byte[] lastApplied = this.readLastApplied();
        return lastApplied == null ? 0L : ByteUtils.bytesToLong((byte[])lastApplied, (int)0);
    }

    @Override
    public long persistedIndex() {
        return this.persistedIndex;
    }

    @Override
    public byte @Nullable [] configuration() {
        try {
            return this.metaCf.get(this.configurationKey);
        }
        catch (RocksDBException e) {
            String msg = String.format("Failed to read configuration from table %d and partition %d", this.tableId, this.partitionId);
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_READ_ERR, msg, e);
        }
    }

    @Override
    public Cursor<TransactionInfo> getCommittedTransactionIds(HybridTimestamp lowerBound, HybridTimestamp upperBound) {
        return this.createCommittedTransactionsCursor(lowerBound, upperBound);
    }

    @Override
    public Cursor<BinaryRowAndRowId> getTransactionData(UUID txId, @Nullable RowId rowId) {
        return this.createTransactionDataCursor(txId, rowId);
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.storageBridge.flush();
    }

    @Override
    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        if (leaseStartTime == this.leaseStartTime) {
            return;
        }
        assert (leaseStartTime > this.leaseStartTime) : IgniteStringFormatter.format((String)"Updated lease start time should be greater than current [current={}, updated={}]", (Object[])new Object[]{this.leaseStartTime, leaseStartTime});
        this.saveLease(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
        this.leaseStartTime = leaseStartTime;
    }

    private void saveLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        LeaseInfo leaseInfo = new LeaseInfo(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
        byte[] bytes = VersionedSerialization.toBytes((Object)leaseInfo, (VersionedSerializer)LeaseInfoSerializer.INSTANCE);
        try {
            this.metaCf.put(this.writeOpts, this.leaseKey, bytes);
            this.leaseStartTime = leaseStartTime;
            this.primaryReplicaNodeId = primaryReplicaNodeId;
            this.primaryReplicaNodeName = primaryReplicaNodeName;
        }
        catch (RocksDBException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Override
    public long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.primaryReplicaNodeId;
    }

    @Override
    @Nullable
    public String primaryReplicaNodeName() {
        return this.primaryReplicaNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasOngoingTransactions(HybridTimestamp upperBound) {
        Object object = this.mux;
        synchronized (object) {
            return !this.ongoingTransactions.headSet(upperBound, false).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommitedStorageEmpty(HybridTimestamp lowerBound) {
        Object object = this.mux;
        synchronized (object) {
            return this.commitedTransactions.tailSet(lowerBound, false).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommitedStorageLimitReached(HybridTimestamp lowerBound) {
        Object object = this.mux;
        synchronized (object) {
            return this.commitedTransactions.tailSet(lowerBound, false).size() >= 10;
        }
    }

    private CommittedTransactionsCursor createCommittedTransactionsCursor(HybridTimestamp lowerBound, HybridTimestamp upperBound) {
        byte[] endKey = RocksUtils.incrementPrefix((byte[])this.committedTxKey(upperBound));
        byte[] startKey = this.committedTxKey(lowerBound);
        Slice upperBoundSlice = endKey != null ? new Slice(endKey) : null;
        ReadOptions rocksOptions = new ReadOptions().setTotalOrderSeek(false).setPrefixSameAsStart(true).setIterateUpperBound((AbstractSlice)upperBoundSlice);
        RocksIterator it = this.committedTransactionsCf.newIterator(rocksOptions);
        it.seek(startKey);
        return new CommittedTransactionsCursor(it, rocksOptions, upperBoundSlice);
    }

    private TransactionDataCursor createTransactionDataCursor(UUID txId, @Nullable RowId rowId) {
        byte[] endKey;
        byte[] startKey;
        if (rowId == null) {
            startKey = this.txDataRangeStartKey(txId);
            endKey = RocksUtils.incrementPrefix((byte[])startKey);
        } else {
            startKey = RocksUtils.incrementPrefix((byte[])this.txDataKey(txId, rowId));
            endKey = RocksUtils.incrementPrefix((byte[])this.txDataRangeStartKey(txId));
        }
        return this.createTransactionDataCursor(startKey, endKey);
    }

    private TransactionDataCursor createTransactionDataCursor(byte[] startKey, byte[] endKey) {
        Slice upperBoundSlice = new Slice(endKey);
        ReadOptions iteratorOpts = new ReadOptions().setTotalOrderSeek(true).setIterateUpperBound((AbstractSlice)upperBoundSlice);
        RocksIterator it = this.dataCf.newIterator(iteratorOpts);
        it.seek(startKey);
        return new TransactionDataCursor(it, iteratorOpts, upperBoundSlice);
    }

    OngoingTransactionCursor createOngoingTransactionCursor() {
        byte[] startTxKey = this.ongoingTxStartKey();
        ReadOptions iteratorOpts = new ReadOptions().setPrefixSameAsStart(true);
        RocksIterator it = this.ongoingTransactionsCf.newIterator(iteratorOpts);
        it.seek(startTxKey);
        return new OngoingTransactionCursor(it, iteratorOpts);
    }

    @Override
    public void close() throws Exception {
        this.writeOpts.close();
    }

    private byte[] committedTxStartKey() {
        return ByteBuffer.allocate(6).order(ORDER).putInt(this.tableId).putShort(this.partitionId).array();
    }

    private byte[] committedTxKey(HybridTimestamp timestampKey) {
        return COMMITED_TX_KEY_BUFFER.get().clear().putInt(this.tableId).putShort(this.partitionId).putLong(timestampKey.longValue()).array();
    }

    private byte[] txDataKey(UUID txId, RowId rowId) {
        return TX_DATA_KEY_BUFFER.get().clear().putInt(this.tableId).putShort(this.partitionId).putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).putLong(rowId.mostSignificantBits() ^ Long.MIN_VALUE).putLong(rowId.leastSignificantBits() ^ Long.MIN_VALUE).array();
    }

    private byte[] ongoingTxStartKey() {
        return ONGOING_TX_KEY_BUFFER.get().clear().putInt(this.tableId).putShort(this.partitionId).putLong(0L).array();
    }

    private byte[] ongoingTxKey(HybridTimestamp timestamp) {
        return ONGOING_TX_KEY_BUFFER.get().clear().putInt(this.tableId).putShort(this.partitionId).putLong(timestamp.longValue()).array();
    }

    private byte[] txDataRangeStartKey(UUID txId) {
        return TX_DATA_PREFIX_BUFFER.get().clear().putInt(this.tableId).putShort(this.partitionId).putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).array();
    }

    private byte @Nullable [] readLastApplied() {
        byte[] byArray;
        block8: {
            ReadOptions readOpts = new ReadOptions().setReadTier(ReadTier.PERSISTED_TIER);
            try {
                byArray = this.metaCf.get(readOpts, this.appliedIndexTermKey);
                if (readOpts == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readOpts != null) {
                        try {
                            readOpts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    String msg = String.format("Failed to read last applied index and term: tableId=%d, partId=%d", this.tableId, this.partitionId);
                    throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_READ_ERR, msg, e);
                }
            }
            readOpts.close();
        }
        return byArray;
    }

    private byte @Nullable [] readLease() {
        byte[] byArray;
        block8: {
            ReadOptions readOpts = new ReadOptions().setReadTier(ReadTier.PERSISTED_TIER);
            try {
                byArray = this.metaCf.get(readOpts, this.leaseKey);
                if (readOpts == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readOpts != null) {
                        try {
                            readOpts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    String msg = String.format("Failed to read lease: tableId=%d, partId=%d", this.tableId, this.partitionId);
                    throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_READ_ERR, msg, e);
                }
            }
            readOpts.close();
        }
        return byArray;
    }

    private static byte[] compositeKeyToBytes(int tableId, short partitionId) {
        assert (tableId >= 0) : tableId;
        assert (partitionId >= 0) : partitionId;
        return ByteBuffer.allocate(6).order(ORDER).putInt(tableId).putShort(partitionId).array();
    }

    @VisibleForTesting
    public Set<HybridTimestamp> getOngoingTransactionSet() {
        return this.ongoingTransactions;
    }

    static {
        RocksDB.loadLibrary();
        ORDER = ByteOrder.BIG_ENDIAN;
        TX_DATA_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(38).order(ORDER));
        TX_DATA_PREFIX_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(22).order(ORDER));
        ONGOING_TX_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(22).order(ORDER));
        COMMITED_TX_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocate(14).order(ORDER));
    }

    private static class OngoingTransactionCursor
    extends RocksIteratorAdapter<HybridTimestamp> {
        private final ReadOptions iteratorOpts;

        private OngoingTransactionCursor(RocksIterator iterator, ReadOptions iteratorOpts) {
            super(iterator);
            this.iteratorOpts = iteratorOpts;
        }

        public void close() {
            super.close();
            RocksUtils.closeAll((AbstractNativeReference[])new AbstractNativeReference[]{this.iteratorOpts});
        }

        protected HybridTimestamp decodeEntry(byte[] key, byte[] value) {
            long time = ByteUtils.bytesToLong((byte[])key, (int)6);
            return HybridTimestamp.hybridTimestamp((long)time);
        }
    }

    private static class TransactionDataCursor
    extends RocksIteratorAdapter<BinaryRowAndRowId> {
        private final ReadOptions iteratorOpts;
        private final Slice upperBoundSlice;

        private TransactionDataCursor(RocksIterator iterator, ReadOptions iteratorOpts, Slice upperBoundSlice) {
            super(iterator);
            this.iteratorOpts = iteratorOpts;
            this.upperBoundSlice = upperBoundSlice;
        }

        public void close() {
            super.close();
            RocksUtils.closeAll((AbstractNativeReference[])new AbstractNativeReference[]{this.iteratorOpts, this.upperBoundSlice});
        }

        protected BinaryRowAndRowId decodeEntry(byte[] key, byte[] value) {
            BinaryRow row;
            ByteBuffer keyBuffer = ByteBuffer.wrap(key).order(ORDER);
            keyBuffer.position(keyBuffer.position() + 4);
            int partitionId = Short.toUnsignedInt(keyBuffer.getShort());
            keyBuffer.position(keyBuffer.position() + 16);
            long mostSignificantBits = keyBuffer.getLong() ^ Long.MIN_VALUE;
            long leastSignificantBits = keyBuffer.getLong() ^ Long.MIN_VALUE;
            RowId rowId = new RowId(partitionId, mostSignificantBits, leastSignificantBits);
            BinaryRow binaryRow = row = value.length == 0 ? null : RocksDbUpdatesStorage.deserializeRow(ByteBuffer.wrap(value).order(ORDER));
            assert (row != null) : "It is not expected to have row as null at this point.";
            return new BinaryRowAndRowId(row, rowId, row.schemaVersion() == -1);
        }
    }

    private static class CommittedTransactionsCursor
    extends RocksIteratorAdapter<TransactionInfo> {
        private final ReadOptions iteratorOpts;
        private final Slice upperBoundSlice;

        private CommittedTransactionsCursor(RocksIterator iterator, ReadOptions iteratorOpts, @Nullable Slice upperBoundSlice) {
            super(iterator);
            this.iteratorOpts = iteratorOpts;
            this.upperBoundSlice = upperBoundSlice;
        }

        public void close() {
            super.close();
            RocksUtils.closeAll((AbstractNativeReference[])new AbstractNativeReference[]{this.iteratorOpts, this.upperBoundSlice});
        }

        protected TransactionInfo decodeEntry(byte[] key, byte[] value) {
            assert (value.length == 16) : "Expected UUID (16 byte), was " + value.length;
            long time = ByteUtils.bytesToLong((byte[])key, (int)6);
            HybridTimestamp commitTimestamp = HybridTimestamp.hybridTimestamp((long)time);
            UUID txId = ByteUtils.bytesToUuid((byte[])value);
            return new TransactionInfo(txId, commitTimestamp);
        }
    }
}

