/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery.statistic;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.recovery.statistic.PartitionRecoveryImpl;
import org.gridgain.internal.recovery.statistic.StatisticsProvider;
import org.gridgain.internal.recovery.statistic.TableRecoveryImpl;
import org.gridgain.internal.recovery.statistic.TimedRecovery;
import org.gridgain.internal.recovery.statistic.accumulator.RowsStatisticAccumulator;
import org.gridgain.internal.recovery.statistic.accumulator.TimeStatisticCollector;

public class RecoveryStatistic
extends TimedRecovery
implements StatisticsProvider {
    private final Map<Integer, TableRecoveryImpl> statistics = new ConcurrentHashMap<Integer, TableRecoveryImpl>();

    public TimeStatisticCollector timeStatisticCollector(int tableId) {
        return this.statistics.computeIfAbsent(tableId, id -> new TableRecoveryImpl());
    }

    public RowsStatisticAccumulator rowsStatisticAccumulator(int tableId, int partition) {
        return this.statistics.computeIfAbsent(tableId, id -> new TableRecoveryImpl()).get(partition);
    }

    @Override
    public long recoveredTables() {
        return this.statistics.size();
    }

    @Override
    public long recoveredPartitionsForTable(int tableId) {
        return this.statistics.getOrDefault(tableId, TableRecoveryImpl.EMPTY).partitions();
    }

    @Override
    public long recoveredRows() {
        AtomicLong total = new AtomicLong();
        this.statistics.forEach((tableId, partitions) -> partitions.values().stream().map(PartitionRecoveryImpl::rows).reduce(Long::sum).ifPresent(total::addAndGet));
        return total.get();
    }

    @Override
    public long recoveredRowsForTable(int tableId) {
        return this.statistics.getOrDefault(tableId, TableRecoveryImpl.EMPTY).values().stream().map(PartitionRecoveryImpl::rows).reduce(0L, Long::sum);
    }

    @Override
    public long recoveredRowsForPartition(int tableId, int partitionId) {
        return this.statistics.getOrDefault(tableId, TableRecoveryImpl.EMPTY).getOrDefault(partitionId, PartitionRecoveryImpl.EMPTY).rows();
    }

    @Override
    public long recoveryTime() {
        return this.time();
    }

    @Override
    public long recoveryTimeForTable(int tableId) {
        return this.statistics.get(tableId).time();
    }

    @Override
    public long recoveryTimeForPartition(int tableId, int partitionId) {
        return this.statistics.getOrDefault(tableId, TableRecoveryImpl.EMPTY).getOrDefault(partitionId, PartitionRecoveryImpl.EMPTY).time();
    }
}

