/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.recovery.RecoveryRequest;
import org.gridgain.internal.recovery.RecoveryRequestProcessedListener;
import org.gridgain.internal.recovery.TableInfo;
import org.gridgain.internal.recovery.TableProvider;
import org.gridgain.internal.recovery.TableRecovery;
import org.gridgain.internal.recovery.statistic.RecoveryStatistic;

public class RecoveryManager {
    private final TableProvider tableProvider;
    private final RecoveryRequestProcessedListener requestProcessedListener;

    public RecoveryManager(TableProvider tableProvider, RecoveryRequestProcessedListener requestProcessedListener) {
        this.tableProvider = tableProvider;
        this.requestProcessedListener = requestProcessedListener;
    }

    public CompletableFuture<Long> process(RecoveryRequest request) {
        RecoveryStatistic recoveryStatistic = new RecoveryStatistic();
        List tableRecoveries = request.tables().stream().map(tableInfo -> new TableRecovery(this.tableProvider, (TableInfo)tableInfo, recoveryStatistic, request)).collect(Collectors.toList());
        recoveryStatistic.recoveryStarted();
        CompletableFuture[] recoveryFutures = new CompletableFuture[tableRecoveries.size()];
        for (int i = 0; i < tableRecoveries.size(); ++i) {
            CompletionStage recoveryFuture = ((TableRecovery)tableRecoveries.get(i)).start().whenComplete((v, e) -> {
                if (e != null) {
                    tableRecoveries.forEach(TableRecovery::cancel);
                }
            });
            recoveryFutures[i] = recoveryFuture;
        }
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(recoveryFutures).thenCompose(v -> request.lastInChain() ? this.requestProcessedListener.onRequestProcessed(request) : CompletableFutures.nullCompletedFuture())).thenApply(v -> recoveryStatistic.recoveredRows())).whenComplete((v, e) -> {
            recoveryStatistic.recoveryFinished();
            if (e == null) {
                request.handler().handleRecoveryFinished(recoveryStatistic.recoveredRows(), recoveryStatistic.recoveryTime());
            } else {
                request.handler().handleRecoveryException((Throwable)e);
            }
        });
    }
}

