/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite.internal.partition.replicator.ZoneResourcesManager;
import org.apache.ignite.internal.replicator.Member;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.gridgain.internal.recovery.RecoveryRequest;
import org.gridgain.internal.recovery.TableInfo;

public class RaftLogTruncater {
    private final String nodeName;
    private final TableManager tableManager;
    private final PartitionReplicaLifecycleManager partitionReplicaLifecycleManager;
    private final ReplicaManager replicaManager;
    private final NodeProperties nodeProperties;
    private final IgniteSpinBusyLock busyLock;

    public RaftLogTruncater(String nodeName, TableManager tableManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, ReplicaManager replicaManager, NodeProperties nodeProperties, IgniteSpinBusyLock busyLock) {
        this.nodeName = nodeName;
        this.tableManager = tableManager;
        this.partitionReplicaLifecycleManager = partitionReplicaLifecycleManager;
        this.replicaManager = replicaManager;
        this.nodeProperties = nodeProperties;
        this.busyLock = busyLock;
    }

    public CompletableFuture<Void> truncateRaftLog(RecoveryRequest request) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.nodeProperties.colocationEnabled() ? this.truncateRaftLogForZones(request) : this.truncateRaftLogForTables(request));
    }

    private CompletableFuture<Void> truncateRaftLogForTables(RecoveryRequest request) {
        CompletableFuture[] futures = (CompletableFuture[])request.tables().stream().flatMap(tableInfo -> this.truncateRaftLogForTable(tableInfo.tableId(), tableInfo.partitions())).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private Stream<CompletableFuture<Void>> truncateRaftLogForTable(int tableId, PartitionSet partitions) {
        return partitions.stream().mapToObj(partitionId -> {
            TablePartitionId replicationGroupId = new TablePartitionId(tableId, partitionId);
            return ((CompletableFuture)this.awaitNonEmptyLogForTablePartition(replicationGroupId).thenCompose(v -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.replicaManager.replica((ReplicationGroupId)replicationGroupId)))).thenCompose(this::triggerRaftLogTruncation);
        });
    }

    private CompletableFuture<Void> awaitNonEmptyLogForTablePartition(TablePartitionId tablePartitionId) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            int tableId = tablePartitionId.tableId();
            int partitionId = tablePartitionId.partitionId();
            TableViewInternal table = this.tableManager.cachedTable(tablePartitionId.tableId());
            assert (table != null) : "Missing table: " + tablePartitionId.tableId();
            PendingComparableValuesTracker indexTracker = table.internalTable().getPartitionStorageIndexTracker(partitionId);
            assert (indexTracker != null) : String.format("Missing index tracker: tableId=%d, partitionId=%d", tableId, partitionId);
            return indexTracker.waitFor((Comparable)Long.valueOf(1L));
        });
    }

    private CompletableFuture<Void> truncateRaftLogForZones(RecoveryRequest request) {
        IntOpenHashSet zoneIds = new IntOpenHashSet();
        ArrayList futures = new ArrayList();
        for (TableInfo tableInfo : request.tables()) {
            if (!zoneIds.add(tableInfo.zoneId())) continue;
            this.truncateRaftLogForZone(tableInfo.zoneId(), tableInfo.partitions()).forEach(futures::add);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private Stream<CompletableFuture<Void>> truncateRaftLogForZone(int zoneId, PartitionSet partitions) {
        return partitions.stream().mapToObj(partitionId -> {
            ZonePartitionId replicationGroupId = new ZonePartitionId(zoneId, partitionId);
            return this.replicaManager.replica((ReplicationGroupId)replicationGroupId).thenCompose(replica -> this.awaitNonEmptyLogForZonePartition(replicationGroupId).thenCompose(v -> this.triggerRaftLogTruncation((Replica)replica)));
        });
    }

    private CompletableFuture<Void> awaitNonEmptyLogForZonePartition(ZonePartitionId zonePartitionId) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            ZoneResourcesManager.ZonePartitionResources resources = this.partitionReplicaLifecycleManager.zonePartitionResources(zonePartitionId);
            assert (resources != null) : "Missing resources for: " + zonePartitionId;
            return resources.storageIndexTracker().waitFor((Comparable)Long.valueOf(1L));
        });
    }

    private CompletableFuture<Void> triggerRaftLogTruncation(Replica replica) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            Member member = Member.votingMember((String)this.nodeName);
            return replica.createSnapshotOn(member, true);
        });
    }
}

