/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.table.distributed.BitSetPartitionSet;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;

public class PartitionsCalculator {
    private final Assignment thisNodeAssignment;
    private final MetaStorageManager metaStorageManager;
    private final NodeProperties nodeProperties;

    public PartitionsCalculator(String nodeName, MetaStorageManager metaStorageManager, NodeProperties nodeProperties) {
        this.thisNodeAssignment = Assignment.forPeer((String)nodeName);
        this.metaStorageManager = metaStorageManager;
        this.nodeProperties = nodeProperties;
    }

    public CompletableFuture<Map<Integer, PartitionSet>> calculatePartitions(List<CatalogTableDescriptor> tableDescriptors, long causalityToken) {
        return this.nodeProperties.colocationEnabled() ? this.calculatePartitionsForZones(tableDescriptors, causalityToken) : this.calculatePartitionsForTables(tableDescriptors, causalityToken);
    }

    private CompletableFuture<Map<Integer, PartitionSet>> calculatePartitionsForTables(List<CatalogTableDescriptor> tableDescriptors, long causalityToken) {
        CompletableFuture[] futures = (CompletableFuture[])tableDescriptors.stream().map(tableDescriptor -> this.partitionSetFromStableAssignments(new ByteArray("assignments.stable." + tableDescriptor.id()), causalityToken, key -> RebalanceUtil.extractTablePartitionId((byte[])key, (byte[])RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES))).toArray(CompletableFuture[]::new);
        return CompletableFutures.allOfToList((CompletableFuture[])futures).thenApply(partitionSets -> {
            HashMap result = IgniteUtils.newHashMap((int)tableDescriptors.size());
            for (int i = 0; i < tableDescriptors.size(); ++i) {
                result.put(((CatalogTableDescriptor)tableDescriptors.get(i)).id(), (PartitionSet)partitionSets.get(i));
            }
            return result;
        });
    }

    private CompletableFuture<Map<Integer, PartitionSet>> calculatePartitionsForZones(List<CatalogTableDescriptor> tableDescriptors, long causalityToken) {
        List zoneIds = tableDescriptors.stream().map(CatalogTableDescriptor::zoneId).distinct().collect(Collectors.toList());
        CompletableFuture[] futures = (CompletableFuture[])zoneIds.stream().map(zoneId -> this.partitionSetFromStableAssignments(new ByteArray("zone.assignments.stable." + zoneId), causalityToken, key -> ZoneRebalanceUtil.extractZonePartitionId((byte[])key, (byte[])ZoneRebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES))).toArray(CompletableFuture[]::new);
        return CompletableFutures.allOfToList((CompletableFuture[])futures).thenApply(partitionSets -> {
            HashMap result = IgniteUtils.newHashMap((int)zoneIds.size());
            for (int i = 0; i < zoneIds.size(); ++i) {
                result.put((Integer)zoneIds.get(i), (PartitionSet)partitionSets.get(i));
            }
            return result;
        });
    }

    private CompletableFuture<PartitionSet> partitionSetFromStableAssignments(ByteArray prefix, long causalityToken, final Function<byte[], PartitionGroupId> groupIdExtractor) {
        final CompletableFuture<PartitionSet> result = new CompletableFuture<PartitionSet>();
        this.metaStorageManager.prefix(prefix, causalityToken).subscribe(new Flow.Subscriber<Entry>(){
            final PartitionSet partitions = new BitSetPartitionSet();

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Entry item) {
                Set assignments;
                byte[] value = item.value();
                if (value != null && (assignments = Assignments.fromBytes((byte[])value).nodes()).contains(PartitionsCalculator.this.thisNodeAssignment)) {
                    int partitionId = ((PartitionGroupId)groupIdExtractor.apply(item.key())).partitionId();
                    this.partitions.set(partitionId);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                result.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                result.complete(this.partitions);
            }
        });
        return result;
    }
}

