/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.store;

import java.util.Objects;
import org.gridgain.internal.rbac.store.OperationResult;
import org.jetbrains.annotations.Nullable;

public final class OperationResultContainer<T> {
    private final OperationResult result;
    @Nullable
    private final T value;

    private OperationResultContainer(OperationResult result, @Nullable T value) {
        this.result = result;
        this.value = value;
    }

    public OperationResult result() {
        return this.result;
    }

    @Nullable
    public T value() {
        return this.value;
    }

    public static <T> OperationResultContainer<T> success(@Nullable T value) {
        return OperationResultContainer.create(OperationResult.SUCCESS, value);
    }

    public static <T> OperationResultContainer<T> failure(OperationResult result) {
        return OperationResultContainer.create(result, null);
    }

    public static <T> OperationResultContainer<T> create(OperationResult result, @Nullable T value) {
        return new OperationResultContainer<T>(result, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationResultContainer that = (OperationResultContainer)o;
        return this.result == that.result && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.result, this.value});
    }

    public String toString() {
        return "OperationResultContainer{result=" + this.result + ", value=" + this.value + "}";
    }
}

