/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.authorization;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.eventlog.api.GridGainEventType;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeChecker;
import org.gridgain.internal.rbac.privileges.exception.AuthorizationException;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class AuthorizerImpl
implements Authorizer {
    private static final IgniteLogger LOG = Loggers.forClass(AuthorizerImpl.class);
    private PrivilegeChecker privilegeChecker;
    private final EventLog eventLog;
    private final AtomicBoolean isEnabled = new AtomicBoolean();

    public AuthorizerImpl(EventLog eventLog) {
        this.eventLog = eventLog;
    }

    public AuthorizerImpl() {
        this(EventLog.NOOP);
    }

    public void init(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    public CompletableFuture<Void> authorizeAsync(SecurityContext context, Privilege privilege) {
        if (!this.isEnabled.get()) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (privilege.action().allowSelfAction() && context.authentication().username() != null && context.authentication().username().equals(privilege.selector().objectName())) {
            this.logAuthorizationSuccess(context, privilege);
            return CompletableFutures.nullCompletedFuture();
        }
        Set rolesSet = context.authentication().roles();
        if (rolesSet.contains("gridgain-system-bypass")) {
            this.logAuthorizationSuccess(context, privilege);
            return CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)GridGainSecurity.bypass(() -> this.privilegeChecker.checkAnyAsync(privilege, rolesSet))).thenApply(res -> {
            if (!res.booleanValue()) {
                this.logAuthorizationFailure(context, privilege);
                AuthorizationException exception = new AuthorizationException(Set.of(privilege), rolesSet);
                LOG.error("Authorization failed", (Throwable)exception);
                throw exception;
            }
            this.logAuthorizationSuccess(context, privilege);
            return null;
        });
    }

    public CompletableFuture<Void> authorizeAsync(Privilege privilege) {
        if (!this.isEnabled.get()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.authorizeAsync(SecurityContextHolder.getOrThrow(), privilege);
    }

    public CompletableFuture<Void> authorizeAsync(SecurityContext context, Set<Privilege> privileges) {
        if (!this.isEnabled.get()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Set rolesSet = context.authentication().roles();
        if (rolesSet.contains("gridgain-system-bypass")) {
            this.logAuthorizationSuccess(context, privileges);
            return CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)GridGainSecurity.bypass(() -> this.privilegeChecker.checkAllAsync(privileges, rolesSet))).thenApply(res -> {
            if (!res.isAllowed()) {
                this.logAuthorizationFailure(context, privileges);
                AuthorizationException exception = new AuthorizationException(res.missedPrivileges(), rolesSet);
                LOG.error("Authorization failed", (Throwable)exception);
                throw exception;
            }
            this.logAuthorizationSuccess(context, privileges);
            return null;
        });
    }

    public CompletableFuture<Void> authorizeAsync(Set<Privilege> privileges) {
        if (!this.isEnabled.get()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.authorizeAsync(SecurityContextHolder.getOrThrow(), privileges);
    }

    public void enable(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    private void logAuthorizationSuccess(SecurityContext context, Set<Privilege> privileges) {
        this.logAuthorizationEvent(context, privileges, GridGainEventType.USER_AUTHORIZATION_SUCCESS);
    }

    private void logAuthorizationSuccess(SecurityContext context, Privilege privilege) {
        this.logAuthorizationSuccess(context, Set.of(privilege));
    }

    private void logAuthorizationFailure(SecurityContext context, Set<Privilege> privileges) {
        this.logAuthorizationEvent(context, privileges, GridGainEventType.USER_AUTHORIZATION_FAILURE);
    }

    private void logAuthorizationFailure(SecurityContext context, Privilege privilege) {
        this.logAuthorizationFailure(context, Set.of(privilege));
    }

    private void logAuthorizationEvent(SecurityContext context, Set<Privilege> privileges, GridGainEventType eventType) {
        EventUser user = EventUser.of((String)context.authentication().username(), (String)"basic");
        Event event = eventType.builder().user(user).timestamp(System.currentTimeMillis()).fields(Map.of("privileges", privileges, "roles", context.authentication().roles())).build();
        this.eventLog.log(event);
    }
}

