/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac;

import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.gridgain.internal.rbac.store.OperationResult;

public class AssignmentOperationResult {
    private final OperationResult result;
    private final Set<String> roles;
    private final Set<String> users;
    private final Map<String, Set<String>> assignments;

    private AssignmentOperationResult(OperationResult result, Set<String> roles, Set<String> users, Map<String, Set<String>> assignments) {
        this.result = result;
        this.roles = roles;
        this.users = users;
        this.assignments = assignments;
    }

    public String formatError() {
        switch (this.result) {
            case ROLE_NOT_FOUND: {
                return AssignmentOperationResult.formatRoles(this.roles) + " not found";
            }
            case USER_NOT_FOUND: {
                return AssignmentOperationResult.formatUsers(this.users) + " not found";
            }
            case RA_NOT_FOUND: {
                return AssignmentOperationResult.formatAssignmentsNotFound(this.assignments);
            }
        }
        throw new IllegalArgumentException("Incorrect result " + this.result);
    }

    private static String formatAssignmentsNotFound(Map<String, Set<String>> assignments) {
        if (assignments.size() == 1) {
            return "Role assignment doesn't exist: " + AssignmentOperationResult.formatAssignments(assignments);
        }
        return "Role assignments don't exist:" + System.lineSeparator() + AssignmentOperationResult.formatAssignments(assignments);
    }

    public static String formatAssignments(Map<String, Set<String>> assignments) {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        assignments.forEach((from, to) -> {
            Object names = to.size() == 1 ? AssignmentOperationResult.joinNames(to) : "[" + AssignmentOperationResult.joinNames(to) + "]";
            joiner.add("`" + from + "` -> " + (String)names);
        });
        return joiner.toString();
    }

    private static String formatRoles(Set<String> roles) {
        return roles.size() == 1 ? "Role " + AssignmentOperationResult.joinNames(roles) + " is" : "Roles " + AssignmentOperationResult.joinNames(roles) + " are";
    }

    private static String formatUsers(Set<String> users) {
        return users.size() == 1 ? "User " + AssignmentOperationResult.joinNames(users) + " is" : "Users " + AssignmentOperationResult.joinNames(users) + " are";
    }

    private static String joinNames(Set<String> names) {
        return names.stream().collect(Collectors.joining("`, `", "`", "`"));
    }

    public static AssignmentOperationResult empty(OperationResult result) {
        return new AssignmentOperationResult(result, null, null, null);
    }

    public static AssignmentOperationResult rolesNotFound(Set<String> roles) {
        return new AssignmentOperationResult(OperationResult.ROLE_NOT_FOUND, roles, null, null);
    }

    public static AssignmentOperationResult usersNotFound(Set<String> users) {
        return new AssignmentOperationResult(OperationResult.USER_NOT_FOUND, null, users, null);
    }

    public static AssignmentOperationResult assignmentsNotFound(Map<String, Set<String>> assignments) {
        return new AssignmentOperationResult(OperationResult.RA_NOT_FOUND, null, null, assignments);
    }
}

