/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.rbac.AssignmentOperationResult;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeGrants;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.store.OperationResult;
import org.gridgain.internal.rbac.store.OperationResultContainer;

public class PrivilegeGrantsImpl
implements PrivilegeGrants {
    private final RoleStore roleStore;

    public PrivilegeGrantsImpl(RoleStore roleStore) {
        this.roleStore = roleStore;
    }

    @Override
    public CompletableFuture<OperationResultContainer<AssignmentOperationResult>> grant(Set<Privilege> privileges, Set<String> grantRoles) {
        return this.doAction(grantRoles, role -> Role.builderFrom((Role)role).addPrivileges(privileges).build());
    }

    @Override
    public CompletableFuture<OperationResultContainer<AssignmentOperationResult>> revoke(Set<Privilege> privileges, Set<String> roleNames) {
        return this.doAction(roleNames, role -> Role.builderFrom((Role)role).removePrivileges(privileges).build());
    }

    private CompletableFuture<OperationResultContainer<AssignmentOperationResult>> doAction(Set<String> roleNames, Function<Role, Role> actionFunction) {
        String[] roleNamesArr = roleNames.toArray(new String[0]);
        List roles = this.roleStore.get(roleNamesArr);
        HashSet<String> missingRoles = new HashSet<String>();
        for (int i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.get(i);
            if (role != null) continue;
            missingRoles.add(roleNamesArr[i]);
        }
        if (!missingRoles.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.ROLE_NOT_FOUND, AssignmentOperationResult.rolesNotFound(missingRoles)));
        }
        Stream<CompletableFuture> futures = roles.stream().map(grantRole -> this.roleStore.updateIfExists(grantRole.name(), actionFunction));
        return CompletableFutures.allOf(futures).thenApply(unused -> OperationResultContainer.success(null));
    }
}

