/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.users;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.password.PasswordEncoder;
import org.gridgain.internal.rbac.password.PasswordEncoderRegistry;
import org.gridgain.internal.rbac.password.PasswordEncoding;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserManagement;
import org.gridgain.internal.rbac.users.UserStore;
import org.gridgain.internal.rbac.users.exception.SystemUserModificationException;
import org.gridgain.internal.rbac.users.exception.UserAlreadyExistsException;
import org.gridgain.internal.rbac.users.exception.UserNotFoundException;
import org.gridgain.internal.rbac.users.exception.UserUpdateException;

public class UserManagementImpl
implements UserManagement {
    private final UserStore userStore;
    private final Authorizer authorizer;
    private final PasswordEncoderRegistry passwordEncoderRegistry;

    public UserManagementImpl(Executor executor, UserStore userStore, Authorizer authorizer) {
        this.userStore = userStore;
        this.authorizer = authorizer;
        this.passwordEncoderRegistry = PasswordEncoderRegistry.createDefaultRegistry((Executor)executor);
    }

    public CompletableFuture<Void> createAsync(User user) {
        return this.authorizer.authorizeThenCompose(Action.CREATE_USER, () -> {
            String username = user.username();
            UserManagementImpl.checkSystemUserModification(username, "System user can not be created.");
            return ((CompletableFuture)this.encodePlainTextPasswordOfUser(user).thenCompose(userWithEncodedPassword -> this.userStore.putIfNotExists(username, userWithEncodedPassword))).thenAccept(res -> {
                switch (res) {
                    case SUCCESS: {
                        return;
                    }
                    case USER_EXISTS: {
                        throw new UserAlreadyExistsException(username);
                    }
                }
                throw new IllegalStateException("Unexpected operation result: " + res);
            });
        });
    }

    public CompletableFuture<Void> dropByUsernameAsync(String username) {
        return this.authorizer.authorizeThenCompose(Action.DROP_USER, () -> {
            UserManagementImpl.checkSystemUserModification(username, "System user can not be removed.");
            return this.userStore.removeIfExists(username).thenAccept(res -> {
                switch (res) {
                    case SUCCESS: {
                        return;
                    }
                    case USER_NOT_FOUND: {
                        throw new UserNotFoundException(username);
                    }
                }
                throw new IllegalStateException("Unexpected operation result: " + res);
            });
        });
    }

    public CompletableFuture<User> findByUsernameAsync(String username) {
        Privilege readUserPrivilege = Privilege.builder().action(Action.READ_USER).selector(Selector.user((String)username)).build();
        return this.authorizer.authorizeAsync(readUserPrivilege).thenApply(unused -> {
            User user = (User)this.userStore.get(username);
            if (user == null) {
                throw new UserNotFoundException(username);
            }
            return user;
        });
    }

    public CompletableFuture<Collection<User>> findAllAsync() {
        return this.authorizer.authorizeAsync(Action.READ_USER).thenApply(unused -> this.userStore.getAll());
    }

    public CompletableFuture<Void> updateAsync(String username, User newUser) {
        if (!username.equals(newUser.username())) {
            return CompletableFuture.failedFuture((Throwable)new UserUpdateException("Changing username is not allowed"));
        }
        Privilege editUserPrivilege = Privilege.builder().action(Action.EDIT_USER).selector(Selector.user((String)username)).build();
        return this.authorizer.authorizeThenCompose(editUserPrivilege, () -> {
            UserManagementImpl.checkSystemUserModification(username, "System user can not be modified.");
            return ((CompletableFuture)this.encodePlainTextPasswordOfUser(newUser).thenCompose(userWithEncodedPassword -> this.userStore.updateIfExists(username, UserManagementImpl.modifyUserFunction(userWithEncodedPassword)))).thenAccept(res -> {
                switch (res) {
                    case SUCCESS: {
                        return;
                    }
                    case USER_NOT_FOUND: {
                        throw new UserNotFoundException(username);
                    }
                }
                throw new IllegalStateException("Unexpected operation result: " + res);
            });
        });
    }

    private static void checkSystemUserModification(String username, String message) {
        if (username.equalsIgnoreCase("gridgain-system-user")) {
            throw new SystemUserModificationException(message);
        }
    }

    private static Function<User, User> modifyUserFunction(User newUser) {
        return user -> User.builderFrom((User)user).username(newUser.username()).password(newUser.password()).passwordEncoding(newUser.passwordEncoding()).build();
    }

    private CompletableFuture<User> encodePlainTextPasswordOfUser(User user) {
        if (user.passwordEncoding() == PasswordEncoding.PLAIN) {
            PasswordEncoding defaultPasswordEncoding = PasswordEncoding.getDefault();
            PasswordEncoder passwordEncoder = this.passwordEncoderRegistry.passwordEncoder(defaultPasswordEncoding);
            return passwordEncoder.encodeAsync(user.password()).thenApply(encodedPassword -> User.builderFrom((User)user).passwordEncoding(defaultPasswordEncoding).password(encodedPassword).build());
        }
        return CompletableFuture.completedFuture(user);
    }
}

