/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.internal.rbac.privileges.ObjectTree;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeCheckResult;
import org.gridgain.internal.rbac.privileges.PrivilegeChecker;
import org.gridgain.internal.rbac.privileges.PrivilegeManagement;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.security.context.GridGainSecurity;

public class PrivilegeCheckerImpl
implements PrivilegeChecker {
    private final PrivilegeManagement privilegeManagement;

    public PrivilegeCheckerImpl(PrivilegeManagement privilegeManagement) {
        this.privilegeManagement = privilegeManagement;
    }

    private static boolean parentMatch(Set<Privilege> assignedPrivileges, Privilege privilege) {
        Privilege parentPrivilege = ObjectTree.findParent((Privilege)privilege);
        if (assignedPrivileges.contains(parentPrivilege)) {
            return true;
        }
        if (parentPrivilege == null || ObjectTree.isRoot((Privilege)parentPrivilege)) {
            return false;
        }
        return PrivilegeCheckerImpl.parentMatch(assignedPrivileges, parentPrivilege);
    }

    private static Boolean checkPrivilege(Privilege privilege, Set<Privilege> privileges) {
        if (PrivilegeCheckerImpl.parentMatch(privileges, privilege)) {
            return true;
        }
        return privileges.contains(privilege);
    }

    public CompletableFuture<Boolean> checkAsync(Privilege privilege, String role) {
        return this.fetchPrivilegesAsync(role).thenApply(privileges -> PrivilegeCheckerImpl.checkPrivilege(privilege, privileges));
    }

    public CompletableFuture<Boolean> checkAnyAsync(Privilege privilege, Set<String> roles) {
        AtomicBoolean hasPrivilege = new AtomicBoolean(false);
        CompletableFuture[] array = (CompletableFuture[])roles.stream().map(this::fetchPrivilegesAsync).map(f -> f.thenAccept(privileges -> {
            if (PrivilegeCheckerImpl.checkPrivilege(privilege, privileges).booleanValue()) {
                hasPrivilege.set(true);
            }
        })).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(array).thenApply(v -> hasPrivilege.get());
    }

    public CompletableFuture<PrivilegeCheckResult> checkAllAsync(Set<Privilege> privilegesToCheck, String role) {
        return this.fetchPrivilegesAsync(role).thenApply(grantedPrivileges -> {
            HashSet<Privilege> deniedPrivileges = new HashSet<Privilege>();
            for (Privilege p : privilegesToCheck) {
                if (PrivilegeCheckerImpl.checkPrivilege(p, grantedPrivileges).booleanValue()) continue;
                deniedPrivileges.add(p);
            }
            return deniedPrivileges.isEmpty() ? PrivilegeCheckResult.allowed() : PrivilegeCheckResult.denied(deniedPrivileges);
        });
    }

    public CompletableFuture<PrivilegeCheckResult> checkAllAsync(Set<Privilege> privileges, Set<String> rolesSet) {
        if (rolesSet.isEmpty()) {
            return CompletableFuture.completedFuture(PrivilegeCheckResult.denied(privileges));
        }
        PrivilegeCheckResult[] results = new PrivilegeCheckResult[rolesSet.size()];
        List<String> roles = List.copyOf(rolesSet);
        CompletableFuture[] futures = (CompletableFuture[])IntStream.range(0, roles.size()).mapToObj(id -> (CompletableFuture)GridGainSecurity.bypass(() -> this.checkAllAsync(privileges, (String)roles.get(id)).thenAccept(result -> {
            results[id] = result;
        }))).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(v -> {
            List allMissedPrivileges = Arrays.stream(results).filter(Predicate.not(PrivilegeCheckResult::isAllowed)).map(PrivilegeCheckResult::missedPrivileges).collect(Collectors.toList());
            if (!allMissedPrivileges.isEmpty()) {
                HashSet missedPrivileges = new HashSet((Collection)allMissedPrivileges.get(0));
                for (int i = 1; i < allMissedPrivileges.size(); ++i) {
                    missedPrivileges.retainAll((Collection)allMissedPrivileges.get(i));
                }
                if (!missedPrivileges.isEmpty()) {
                    return PrivilegeCheckResult.denied(missedPrivileges);
                }
            }
            return PrivilegeCheckResult.allowed();
        });
    }

    public CompletableFuture<PrivilegeCheckResult> checkSelfPrivilegesAsync(Privilege privilege, String username) {
        if (!privilege.action().allowSelfAction()) {
            throw new IllegalStateException("Privilege " + privilege + " does not allow self action. Please, use PrivilegeChecker#checkAsync instead.");
        }
        if (username.equals(privilege.selector().objectName())) {
            return CompletableFuture.completedFuture(PrivilegeCheckResult.allowed());
        }
        return CompletableFuture.completedFuture(PrivilegeCheckResult.denied(Set.of(privilege)));
    }

    private CompletableFuture<Set<Privilege>> fetchPrivilegesAsync(String role) {
        return this.privilegeManagement.getPrivilegesAsync(role).exceptionally(e -> {
            if (e instanceof CompletionException && e.getCause() instanceof RoleNotFoundException) {
                return new HashSet();
            }
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)e);
        });
    }
}

