/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.ActionAlias;
import org.gridgain.internal.rbac.privileges.ObjectTree;
import org.gridgain.internal.rbac.privileges.ObjectType;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.privileges.exception.IllegalPrivilegeException;

public class PrivilegeAlias {
    private final ActionAlias alias;
    private final Selector selector;

    private PrivilegeAlias(ActionAlias alias, Selector selector) {
        this.alias = alias;
        this.selector = selector;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PrivilegeAlias fromAction(ActionAlias actionAlias) {
        return PrivilegeAlias.builder().alias(actionAlias).build();
    }

    public Set<Privilege> toPrivileges() {
        return this.alias.actions().stream().filter(action -> {
            Set<ObjectType> ancestors = ObjectTree.findAncestors(action.applicableObjectType());
            return action.applicableObjectType() == this.selector.objectType() || ancestors.contains((Object)this.selector.objectType());
        }).map(a -> Privilege.builder().action((Action)((Object)a)).selector(this.selector).build()).collect(Collectors.toSet());
    }

    public String format() {
        String selectorRawString = this.selector.toRawString();
        return this.alias.name() + (String)(selectorRawString == null ? "" : " on " + selectorRawString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeAlias that = (PrivilegeAlias)o;
        return this.alias == that.alias && Objects.equals(this.selector, that.selector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.selector});
    }

    public static class Builder {
        private ActionAlias alias;
        private Selector selector;
        private String rawSelector;

        public Builder alias(ActionAlias alias) {
            this.alias = alias;
            return this;
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder selector(String rawSelector) {
            this.rawSelector = rawSelector;
            return this;
        }

        public PrivilegeAlias build() {
            if (this.alias == null) {
                throw new IllegalPrivilegeException("Alias is not specified");
            }
            if (this.selector != null && this.rawSelector != null) {
                throw new IllegalPrivilegeException("Both selector and rawSelector are specified");
            }
            if (this.rawSelector != null) {
                this.selector = this.parseSelector(this.rawSelector);
            }
            if (this.selector == null && this.rawSelector == null) {
                this.selector = Selector.cluster();
            }
            return new PrivilegeAlias(this.alias, this.selector);
        }

        private Selector parseSelector(String rawSelector) {
            String[] split = rawSelector.split("\\.");
            if (split.length == 1) {
                if (ObjectType.CLUSTER.name().equalsIgnoreCase(split[0])) {
                    return Selector.cluster();
                }
                return Selector.schema(split[0]);
            }
            if (split.length == 2) {
                return Selector.table(split[0], split[1]);
            }
            throw new IllegalPrivilegeException("Cannot parse selector " + rawSelector);
        }
    }
}

