/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.users;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.rbac.password.PasswordEncoding;
import org.gridgain.internal.rbac.users.exception.UserValidationException;

public class User {
    private final String username;
    private final String password;
    private final PasswordEncoding passwordEncoding;
    private final Set<String> roles;

    private User(String username, String password, PasswordEncoding passwordEncoding, Set<String> roles) {
        this.username = username;
        this.password = password;
        this.passwordEncoding = passwordEncoding;
        this.roles = roles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(User user) {
        return User.builder().username(user.username()).password(user.password()).passwordEncoding(user.passwordEncoding()).addRoles(user.roles());
    }

    public String username() {
        return this.username;
    }

    public Set<String> roles() {
        return this.roles;
    }

    public String password() {
        return this.password;
    }

    public PasswordEncoding passwordEncoding() {
        return this.passwordEncoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.username, user.username);
    }

    public int hashCode() {
        return Objects.hash(this.username);
    }

    public String toString() {
        return "User{username='" + this.username + "', password=******, passwordEncoding='" + this.passwordEncoding + "'}";
    }

    public static class Builder {
        private String username;
        private String password;
        private PasswordEncoding passwordEncoding = PasswordEncoding.PLAIN;
        private final Set<String> roles = new HashSet<String>();

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder passwordEncoding(PasswordEncoding passwordEncoding) {
            this.passwordEncoding = passwordEncoding;
            return this;
        }

        public Builder addRoles(Set<String> roles) {
            this.roles.addAll(roles);
            return this;
        }

        public Builder removeRoles(Set<String> roles) {
            this.roles.removeAll(roles);
            return this;
        }

        public User build() {
            if (this.username == null || this.username.isBlank()) {
                throw new UserValidationException("`username` should not be null or empty string");
            }
            if (this.password == null || this.password.isBlank()) {
                throw new UserValidationException("`password` should not be null or empty string");
            }
            return new User(this.username, this.password, this.passwordEncoding, this.roles);
        }
    }
}

