/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.roles;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.users.User;

public class RoleView {
    private final Role role;
    private final Set<User> assignedUsers;

    private RoleView(Role role, Set<User> assignedUsers) {
        this.assignedUsers = assignedUsers;
        this.role = role;
    }

    public static RoleViewBuilder builder() {
        return new RoleViewBuilder();
    }

    public String roleName() {
        return this.role.name();
    }

    public Set<User> assignedUsers() {
        return this.assignedUsers;
    }

    public Set<Privilege> privileges() {
        return this.role.privileges();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleView roleView = (RoleView)o;
        return Objects.equals(this.role, roleView.role) && Objects.equals(this.assignedUsers, roleView.assignedUsers);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.assignedUsers);
    }

    public String toString() {
        return "RoleView{role='" + this.role + "', assignedUsers=" + this.assignedUsers + "}";
    }

    public static class RoleViewBuilder {
        private Role role;
        private Set<User> assignedUsers = new HashSet<User>();

        public RoleViewBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public RoleViewBuilder assignedUsers(Set<User> assignedUsers) {
            this.assignedUsers = assignedUsers;
            return this;
        }

        public RoleView build() {
            return new RoleView(this.role, this.assignedUsers);
        }
    }
}

